<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code Payment</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: white;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .container {
            width: 80%;
            max-width: 400px;
            position: relative;
            background-image: url("{{ asset('Qr_Code.jpg') }}");
            background-size: cover;
            background-position: center;
            border-radius: 10px;
            text-align: center;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            color: hsl(0, 29%, 95%);
            overflow: hidden;
        }

        .container::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(113, 86, 217, 0.6);
            border-radius: 10px;
            z-index: 0;
        }

        .container>* {
            position: relative;
            z-index: 1;
        }

        .logo {
            margin-top: 20px;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            color: hsl(0, 11%, 95%);
            margin-top: 10px;
            margin-bottom: 30px;
        }

        .qr-code-container {
            width: 80%;
            max-width: 300px;
            height: 200px;
            /* border: 2px dashed #7156d9; */
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        .qr-code svg {
            width: 100%;
            height: auto;
        }

        .thank-you {
            font-size: 18px;
            color: hsl(0, 22%, 93%);
            margin-top: 20px;
            font-weight: bold;
        }

        .contact-info {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
            font-size: 14px;
            color: hsl(0, 33%, 94%);
        }

        .contact-info div {
            display: flex;
            align-items: center;
        }

        .contact-info img {
            width: 20px;
            height: 20px;
            margin-right: 5px;
        }

        .footer {
            font-size: 14px;
            color: hsl(0, 20%, 95%);
            margin-top: 20px;
        }

        .printbtn {
            background-color: #0bc8d6;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        /* Print Styles */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
            }

            .container {
                width: 80%;
                max-width: 400px;
                border-radius: 10px;
                text-align: center;
                padding: 20px;
                color: white;
            }

            .printbtn {
                visibility: hidden;
            }

            .qr-code-container {
                /* border: 2px dashed #7156d9; */
                padding: 10px;
            }
        }
    </style>

</head>

<body>
    <div class="container">
        <div class="logo">
            <img width="auto" height="auto" src="{{ asset('storage/company/' . siteinfo()->img_url) }}"
                style="display: block; margin-left: auto; margin-right: auto; border-radius: 50%; height: 4em; object-fit: cover; width: 4em;" alt="No Image">
            <h4 style="text-align: center">{{ siteinfo()->name ?? '' }}</h4>
        </div>

        <h4 style="text-align: center;">Username: {{ $client->userid }} </h4>
        <div class="title">QR কোড স্ক্যান করে পেমেন্ট করুন</div>

        <div class="qr-code-container">
            <div class="qr-code">{!! $qrCode !!}</div>
        </div>

        <div class="thank-you">ধন্যবাদ</div>

        <div style="display: flex; justify-content: center; align-items: center; margin-top: 10px;">
            <button class="printbtn" onclick="window.print()">Print</button>
        </div>

        <div class="contact-info">
            <div>
                <span>Address: {{ siteinfo()->address ?? '' }}</span>
            </div>
            <div>
                <span>Contact: {{ siteinfo()->mobile ?? '' }}</span>
            </div>
        </div>

        <div class="footer">Powered by YetFix Limited</div>
    </div>
</body>

</html>
