<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PayrollEmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::withSum('payroll', 'net_salary')
            ->withSum('employeePayment', 'amount')
            ->where('salary_generate', 1)
            ->get();

        // dd($employees);

        return view('payroll.employee.index',[
            'page_title' => 'Payroll Employee',
            'employees' => $employees,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('payroll.employee.create',[
            'page_title' => 'Create Payroll Employee',
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'nid' => 'required|unique:employees,nid',
        ]);

        $employee = new Employee();

        $employee->employee_id = Carbon::now()->format('Y').'-'.rand(1000,9999);
        $employee->name = $request->name;
        $employee->email = $request->email;
        $employee->mobile_personal = $request->mobile_personal;
        $employee->current_address = $request->current_address;
        $employee->nid = $request->nid;
        $employee->department = $request->department;
        $employee->current_designation = $request->current_designation;
        $employee->join_date = $request->join_date;
        $employee->blode_group = $request->blode_group;
        $employee->current_salary = $request->current_salary;
        $employee->house_allowance = $request->house_allowance;
        $employee->transport_allowance = $request->transport_allowance;
        $employee->other_allowance = $request->other_allowance;
        $employee->bonous = $request->bonous;
        $employee->advance_salary = $request->advance_salary;
        $employee->working_day = $request->working_day ?? 30;
        $employee->absent_day = $request->absent_day ?? 0;
        $employee->salary_generate = $request->salary_generate;
        $employee->save();

        Toastr::success('Employee Created Successfully');
        return redirect()->route('payrollEmployee.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return view('payroll.employee.show',[
            'page_title' => 'Employee Details',
            'employee' => Employee::findOrFail($id),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        return view('payroll.employee.edit',[
            'page_title' => 'Edit Payroll Employee',
            'employee' => Employee::findOrFail($id),
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'nid' => 'required|unique:employees,nid,'.$id,
        ]);

        $employee = Employee::findOrFail($id);

        $employee->name = $request->name;
        $employee->email = $request->email;
        $employee->mobile_personal = $request->mobile_personal;
        $employee->current_address = $request->current_address;
        $employee->nid = $request->nid;
        $employee->department = $request->department;
        $employee->current_designation = $request->current_designation;
        $employee->join_date = $request->join_date;
        $employee->blode_group = $request->blode_group;
        $employee->current_salary = $request->current_salary;
        $employee->house_allowance = $request->house_allowance;
        $employee->transport_allowance = $request->transport_allowance;
        $employee->other_allowance = $request->other_allowance;
        $employee->bonous = $request->bonous;
        $employee->advance_salary = $request->advance_salary;
        $employee->working_day = $request->working_day ?? 30;
        $employee->absent_day = $request->absent_day ?? 0;
        $employee->salary_generate = $request->salary_generate;
        $employee->save();

        Toastr::success('Employee Updated Successfully');
        return redirect()->route('payrollEmployee.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
