<div class="my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
    <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
        <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">

            <table id="dataTable" class="min-w-full divide-y divide-gray-200">

                <thead>
                    <tr>
                        <th scope="col" class="no-wrap">
                            ID
                        </th>
                        <th scope="col" class="no-wrap">
                            User name
                        </th>
                        <th scope="col" class="no-wrap">
                            Status
                        </th>
                        <th scope="col" class="no-wrap">
                            Expire
                        </th>
                        <th scope="col" class="no-wrap">
                            Bill Info
                        </th>
                        <th scope="col" class="no-wrap">
                            Package
                        </th>
                        <th scope="col" class="no-wrap">
                            POP
                        </th>
                        <th>
                            Name
                        </th>
                        <th>
                            Contact
                        </th>
                        <th scope="col" style="width:350px">
                            User Info
                        </th>
                        <th scope="col" class="no-wrap">
                            Created Date
                        </th>
                        <th scope="col" class="noprin">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($list as $r)
                        <tr @if ($r->clients_status == 'deactive') class="deactive" @endif>
                            <td class="text-center">
                                <a class="btn btn-info btn-block btn-xs"
                                    href="{{ route('getPaymentHistory', $r->id) }}">@php(printf('CID%04d', $r->id))</a>
                                <a href="{{ route('getCustomerLogHistory', $r->userid) }}"
                                    class="noprint btn btn-primary btn-xs btn-block">Log</a>
                            </td>
                            <td class="no-wrap">
                                {{ $r->userid }}
                                <br>
                                {{ $r->password }}
                                {{-- <br>
                                @if (isset($online) && in_array($r->userid, $online))
                                    <span class="btn btn-success btn-xs">Online</span>
                                @else
                                    <span class="btn btn-danger btn-xs">Ofline</span>
                                @endif --}}
                            </td>

                            <td
                                class="
                            @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                            @elseif($r->clients_status == 'deactive')
                                bg-secondary
                                @elseif($r->clients_status == 'disable')
                                bg-warning
                            @elseif($r->clients_status == 'active')
                             bg-success @endif
                            ">
                                <x-Custom.Status status="{{ $r->clients_status }}" />
                            </td>
                            <td class="
                            @if ($r->deleted_at != null || $r->clients_status == 'expired' ) deactive bg-danger
                            @elseif($r->clients_status == 'deactive')
                                bg-secondary
                                @elseif($r->clients_status == 'disable')
                                bg-warning
                            @elseif($r->clients_status == 'active')
                             bg-success @endif
                            "
                                style="min-width:140px;text-align:left">
                                BD: {{ date('d-M-Y', strtotime($r->expire_date)) }}<br>
                                PD:
                                {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                            </td>


                            <td style="min-width:130px">
                                <p style="font-size:14px;">
                                    B Cycle: {{ $r->billing_cycle }} <br>
                                    @if (isset($r->pop->bill_generate) && $r->pop->bill_generate == 'yes')
                                        B Amount: @role('Sub Reseller')
                                            @if ($r->pop->subreseller == 'yes')
                                                {{ $r->subpack->sub_package_rate }}
                                            @else
                                                {{ $r->packages->package_rate }}
                                            @endif
                                        @else
                                            {{ $r->packages->package_rate }}
                                        @endrole <br>
                                        OTC : {{ $r->clientsinfo->otc }} <br>
                                        @if ($r->clientsinfo->otc_due > 0)
                                            <span class="bg-danger pl-1 pr-1"> OTC Due: {{ $r->clientsinfo->otc_due }}</span>
                                        @endif
                                    @endif
                                </p>
                                @if($r->customerAccount)
                                <p class="text-danger">Due: {{ $r->customerAccount->dueAmount }}</p>
                                @endif
                            </td>


                            <td>

                                @can('show-sub-package')
                                    <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }}</span>
                                @endcan

                                @can('show-mother-package')
                                    <span class="d-block badge badge-info"> {{ $r->packages->package_name ?? '' }}</span>
                                @endcan


                                {{-- @if ($r->pop->subreseller == 'yes')
                                @role('Sub Reseller')

                                    {{ $r->subpack->name }}

                                @endrole
                                @else
                                    {{ $r->packages->package_name }}
                                @endif
                            {{-- @else

                                {{ $r->packages->package_name }} --}}


                            </td>

                            <td class="no-wrap">
                                {{ $r->pop->popname ?? '' }}
                            </td>

                            <td>

                                {{ $r->clientsinfo->clients_name ?? '' }}
                            </td>
                            <td>
                                {{ $r->clientsinfo->contact_no ?? '' }}
                            </td>



                            <td style="width:350px;">
                                <p style="font-size:14px;">
                                    Flat No: {{ $r->clientsinfo->flat_no ?? '' }} ,
                                    Building Name: {{ $r->clientsinfo->building_name ?? '' }} ,<br>
                                    Road No: {{ $r->clientsinfo->road_no ?? '' }} ,<br>
                                    Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }} ,
                                    Area : {{ $r->clientsinfo->area ?? '' }} ,
                                    Latitude : {{ $r->clientsinfo->client_latitude ?? '' }} ,
                                    Longitude : {{ $r->clientsinfo->client_longitude ?? '' }} </p>
                            </td>

                            <td class="whitespace-nowrap">
                                {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                            </td>


                        <td class="text-center noprint" style="width:160px;">
                            <div class="dropdown">
                                <button class="btn btn-primary dropdown-toggle" type="button"
                                    id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="false">
                                    Action
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <a href="{{ route('clients.show', $r->id) }}"
                                        class="dropdown-item">Details</a>
                                    @can('mac-customer_edit')
                                        <a href="{{ route('clients.edit', $r->id) }}"
                                            class="dropdown-item">Edit</a>
                                    @endcan
                                    <div class="mb-1"></div>
                                    @if ($r->client_approval == 'pending')
                                        @can('new-customer-approve')
                                            <form method="POST" action="{{ route('clinetApprove', $r->id) }}">
                                                @method('post')
                                                @csrf
                                                <input type="hidden" name="user_approve" value="{{ $r->id }}">
                                                <button
                                                    onclick="return confirm('Are you sure you want to Approved this user ?');"
                                                    type="submit" class="dropdown-item">Approve</button>
                                            </form>
                                        @endcan
                                    @endif
                                    @if ($r->clients_status == 'disable')
                                        @can('id-enable')
                                            <a href="{{ route('idEnable', $r->id) }}"
                                                onclick="return confirm('Are you sure you want to Enable the ID?');"
                                                class="dropdown-item">Enable</a>
                                        @endcan
                                    @endif
                                    @if ($r->clients_status == 'active')
                                        @can('id-disable')
                                            <a href="{{ route('idDisable', $r->id) }}"
                                                onclick="return confirm('Are you sure you want to Disable the ID?');"
                                                class="confirmDisable dropdown-item">Disable</a>
                                        @endcan
                                    @endif
                                    @can('mac-customer_destroy')
                                        <form method="POST" action="{{ route('clients.destroy', $r->id) }}">
                                            @method('DELETE')
                                            @csrf
                                            <button
                                                onclick="return confirm('Are you sure you want to Delete this user ?');"
                                                type="submit" class="dropdown-item">Delete</button>
                                        </form>
                                    @endcan
                                    @can('customer-recharge')
                                        @if ($r->clients_status == 'active')
                                        @endif
                                        @if ($r->clients_status == 'expired')
                                        @endif
                                    @endcan
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>

        <div class="p-5">
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
</div>
</div>
