<?php

namespace App\Http\Controllers;

use App\Models\District;
use App\Models\Division;
use App\Models\Thana;
use App\Models\Upazila;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class LocationController extends Controller
{

    public function index()
    {
        $districts = District::with('division')->get();

        return view('locations.index', compact('districts'));
    }

    public function upazilaList()
    {
        $upazilas = Upazila::with('district')->get();

        return view('locations.upazila', compact('upazilas'));
    }
    public function thanaList()
    {
        $thanas = Thana::with('upazila')->get();

        return view('locations.thana', compact('thanas'));
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        //
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $divisions = Division::all();
        $district = District::find($id);

        return view('locations.districtEdit', compact('divisions', 'district'));
    }

    public function update(Request $request, $id)
    {
        $district = District::find($id);
        $district->division_id = $request->division_id;
        $district->name = $request->name;
        $district->bn_name = $request->bn_name;
        $district->save();

        Toastr::success("successfully Updated");
        return redirect()->route('location.index');
    }

    public function upazilaEdit($id)
    {
        $districts = District::all();
        $upazila = Upazila::find($id);

        return view('locations.upazilaEdit', compact('districts', 'upazila'));
    }

    public function upazilaUpdate(Request $request)
    {
        $upazila = Upazila::find($request->id);
        $upazila->district_id = $request->district_id;
        $upazila->name = $request->name;
        $upazila->bn_name = $request->bn_name;
        $upazila->save();

        Toastr::success("successfully Updated");
        return redirect()->route('upazilaList');
    }

    public function thanaEdit($id)
    {
        $upazilas = Upazila::all();
        $thana = Thana::find($id);

        return view('locations.thanaEdit', compact('upazilas', 'thana'));
    }

    public function thanaUpdate(Request $request)
    {
        $upazila = Thana::find($request->id);
        $upazila->upazila_id = $request->upazila_id;
        $upazila->name = $request->name;
        $upazila->bn_name = $request->bn_name;
        $upazila->save();

        Toastr::success("successfully Updated");
        return redirect()->route('thanaList');
    }


    public function destroy($id)
    {
        //
    }
}
