@extends('layout.app')
@section('content')

<div class="flex flex-col mt-5">
    <div class=" bg-white p-6 rounded-lg">

        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg" id="PrintSection">
                    <div class="flex justify-between noprint">
                        <div class="p-2 mb-5">
                            <a class="noprint cursor-pointer mt-2 uppercase px-2 py-1 rounded inline-block bg-green-600 text-xs text-white"
                                href="{{ route('printMonthlyPaid') }}" target="_blank"><i class="fa fa-print"></i> Print
                            </a>
                        </div>

                        {{-- <button type="button" onclick="window.print()">
                            <i class="fa fa-print"></i>
                        </button> --}}
                    </div>

                    <table id="dataTable" class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    ID
                                </th>
                                <th scope="col"
                                    class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Paid Amount
                                </th>
                                <th scope="col"
                                    class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Client ID
                                </th>
                                <th scope="col"
                                    class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Created Date
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($sales as $r)
                            <tr>
                                <td class="whitespace-nowrap">
                                    {{ $r->id}}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{$r->paid_amount}}
                                </td>
                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{$r->client_id}}
                                </td>
                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{$r->created_at}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<style>
    .pop {
        display: none;
    }
    @media print {
        table tr th,
        table,
        tr,
        td {
            font-size: 10px !important;
            padding: 2px !important;
        }
    }
</style>

@endsection
