@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">
                                ID
                            </th>
                            <th scope="col" class="text-center">
                                Package Name
                            </th>
                            @canany(['show-package-rate', 'specific_management_services'])

                                <th scope="col" class="text-center">
                                    Package Rate
                                </th>
                            @endcan

                            @canany(['show-package-rate', 'specific_management_services'])
                                @if (checkSettings('ResellerClientOnlineRecharge') == 'enable' && checkSettings('setClientPaymentAmountToClient') != 'enable' )
                                    <th scope="col" class="text-center">
                                        Client payment amount
                                    </th>
                                @endif
                            @endcan


                            @if (checkSettings('resseller-name-in-package') == 'enable')
                                @can('reseller-show-in-package')
                                    <th scope="col" class="text-center">Reseller Name</th>
                                @endcan
                            @endif
                            @can('ip-pool')
                                <th scope="col" class="text-center">
                                    @if (checkAPI())
                                        Profile Name
                                    @else
                                        Pool Name
                                    @endif
                                </th>
                            @endcan


                            <th scope="col" class="text-center">
                                Create Date
                            </th>
                            @can('pack-commission')
                                <th scope="col">
                                    Commission
                                </th>
                            @endcan
                            <th scope="col" class="text-center">

                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($list as $r)
                            <tr>
                                <td class="text-center">
                                    {{ $r->id }}
                                </td>
                                <td class="text-center">
                                    {{ $r->package_name }}
                                </td>


                                @canany(['show-package-rate', 'specific_management_services'])
                                    <td class="text-center">
                                        {{ $r->package_rate }}
                                    </td>
                                @endcan

                                @canany(['show-package-rate', 'specific_management_services'])
                                @if (checkSettings('ResellerClientOnlineRecharge') == 'enable' && checkSettings('setClientPaymentAmountToClient') != 'enable' )
                                    <td class="text-center">
                                        {{ $r->client_payment_amount }}
                                    </td>
                                    @endif
                                @endcan

                                @if (checkSettings('resseller-name-in-package') == 'enable')
                                    @can('reseller-show-in-package')
                                        <td class="overflow-auto">
                                            <div class="overflow-auto" style="height:100px">
                                                @foreach ($resellers as $reseller)
                                                    @if (in_array($r->id, explode(',', $reseller->package_list)))
                                                        <span class="btn btn-warning p-1 mb-1">{{ $reseller->name }}</span>
                                                    @endif
                                                @endforeach

                                            </div>
                                        </td>
                                    @endcan
                                @endif

                                @can('ip-pool')
                                    <th scope="col" class="text-center">
                                        @if (checkAPI())
                                            {{ $r->profile_name }}
                                        @else
                                            {{ $r->pool_name }}
                                        @endif
                                    </th>
                                @endcan



                                <td class="text-center">
                                    {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                                </td>
                                @can('pack-commission')
                                    <td class="text-center">
                                        {{ $r->commission }}
                                    </td>
                                @endcan
                                <td class="d-flex">
                                    @can('package_edit')
                                        <a href="{{ route('packages.edit', $r->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                    @endcan
                                    @can('package_destroy')
                                        <form id="deltepackage" action="{{ route('packages.destroy', $r->id) }}" method="POST"
                                            class="">
                                            @method('DELETE')
                                            @csrf
                                            <button onclick="return confirm('are you want to delete the package?')"
                                                type="delete" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    @endcan
                                    @can('view-package-log-history')
                                        <a href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'Package']) }}"
                                            class="btn btn-primary pull-right btn-sm">History</a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>

    </div>
@endsection
