<?php

namespace App\Jobs;

use Carbon\Carbon;
use App\Models\User_log;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use App\Classes\ExpireCustomerDeactive;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class ExpireCustomerDeactiveByListJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    protected $lists;
    private $authId;
    public function __construct($lists, $authId)
    {
        $this->lists = $lists;
        $this->authId = $authId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new ExpireCustomerDeactive)->deactiveBatch($this->lists, $this->authId);
    }
}
