<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\LineShift;
use App\Models\Pop;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class LineShiftController extends Controller
{

    public function index()
    {
        $data = [
            'list' => LineShift::with('pops', 'client', 'client.clientsinfo')->get()
        ];

        return view('lineShift.index', $data);
    }


    public function create()
    {
        $data = [
            'clients' => Client::all()
        ];

        return view('lineShift.create', $data);
    }

    public function getCustomerList(Request $request)
    {
        $customers = Client::list()->Where('userid', 'like', "%{$request->search}%")->get();

        return $customers;
    }

    // public function getClientLineShiftpop(Request $request)
    // {
    //     if (request()->ajax() && !empty($request->id)) {

    //         $pop = '';
    //         $list = Client::list()->selectRaw('id,pop_id,userid')
    //             ->where('id', $request->id)->first();

    //         $pop .= "<option value='" . $list->pop_id . "'>" . $list->pops->popname . "</option>";

    //         echo $pop;
    //     }
    // }

    // public function getClientLineShiftaddress(Request $request)
    // {
    //     if (request()->ajax() && !empty($request->id)) {

    //         $list = Client::list()->selectRaw('id,pop_id,userid')
    //             ->where('id', $request->id)->first();

    //         $address = 'Flat-' . $list->clientsinfo->flat_no . ', Building-' . $list->clientsinfo->building_name . ', Road-' . $list->clientsinfo->road_no . ', Block-' . $list->clientsinfo->block_sector;

    //         echo $address;
    //     }
    // }


    public function store(Request $request)
    {
        $request->validate([
            // 'contact' => 'digits:11',
            'contact' => 'required|string|unique:line_shifts|min:11|max:11',
        ]);
        // dd($request->all());
        $line = new LineShift();
        $line->client_userid = $request->client_userid;
        $line->pop_id = $request->pop_id;
        $line->old_address = $request->old_address;
        // $line->new_address = $request->new_address;
        $line->shifting_date = $request->shifting_date;
        $line->contact = $request->contact;
        $line->status = $request->status;

        $line->flat_no = $request->flat_no;
        $line->building_no = $request->building_no;
        $line->building_name = $request->building_name;
        $line->road_no = $request->road_no;
        $line->road_name = $request->road_name;
        $line->block_sector = $request->block_sector;
        $line->area = $request->area;
        $line->box = $request->box;
        $line->client_latitude = $request->client_latitude;
        $line->client_longitude = $request->client_longitude;
        $line->save();

        Toastr::success('Information Added Successfully', '', ['progressbar' => true]);
        return redirect()->back();
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        // $lineShift = LineShift::find($id);
        $data = [
            'line' => LineShift::with('pops', 'client', 'client.clientsinfo')->find($id),
            // 'clients' => Client::all(),
            // 'pop' => Pop::where('id', $lineShift->pop_id)->first()
        ];

        return view('lineShift.edit', $data);
    }


    public function update(Request $request, $id)
    {
        // dd($request->all());
        $this->validate($request, [
            // 'contact' => 'digits:11',
            'contact' => 'required|string|min:11|max:11|unique:line_shifts,contact,' . $id,
        ]);

        $line = LineShift::find($request->id);
        $line->client_userid = $request->client_userid;
        $line->pop_id = $request->pop_id;
        $line->old_address = $request->old_address;
        $line->new_address = $request->new_address;
        $line->shifting_date = $request->shifting_date;
        $line->contact = $request->contact;
        $line->status = $request->status;

        $line->flat_no = $request->flat_no;
        $line->building_no = $request->building_no;
        $line->building_name = $request->building_name;
        $line->road_no = $request->road_no;
        $line->road_name = $request->road_name;
        $line->block_sector = $request->block_sector;
        $line->area = $request->area;
        $line->box = $request->box;
        $line->client_latitude = $request->client_latitude;
        $line->client_longitude = $request->client_longitude;
        $line->update();

        if($line->status == 'Done' || $line->status == 'Done and Cable Remove'){

            $client = Clientsinfo::where('client_id', $line->client_userid)->first();
            $client->flat_no = $request->flat_no;
            $client->building_no = $request->building_no;
            $client->building_name = $request->building_name;
            $client->road_no = $request->road_no;
            $client->road_name = $request->road_name;
            $client->block_sector = $request->block_sector;
            $client->area = $request->area;
            $client->box = $request->box;
            $client->client_latitude = $request->client_latitude;
            $client->client_longitude = $request->client_longitude;
            $client->update();

            Toastr::success('Cilents New Address Updated Successfully', '', ['progressbar' => true]);
        }

        Toastr::success('Information Updated Successfully', '', ['progressbar' => true]);
        return redirect()->route('line-shift.index');
    }


    public function destroy($id)
    {
        //
    }
}
