<?php

namespace App\Imports;

use App\Http\Controllers\PaymentController;
use App\Models\Balance;
use App\Models\Billpayment;
use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\Payment;
use App\Models\Pop;
use App\Models\ReselleBalanceLogReport;
use App\Models\ResellerRechargeReport;
use App\Services\ResellerClientOlineRechargeService;
use Carbon\Carbon;
use Exception;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class PaymentToResellerBalanceLogAndRecharge implements ToCollection
{
    use Importable;

    public function collection(Collection $rows)
    {
        // userid wise info update

        $count = 0;
        foreach ($rows as $row) {
            $client = Client::with('pop','clientsinfo')->find($row[4]);
            $amount = $row[2];
            $trx_id = $row[8];

            $payment_method = $row[9];

            $user_id = $row[5];

            $reseller_id = $client->pop->reseller_id;

            $checkResellerRecharge = ResellerRechargeReport::where('txn_id', 'like', "%{$trx_id}%")->count();
            $phpDate = Date::excelToDateTimeObject($row[6]);


            // dd(Carbon::parse($phpDate)->format('Y-m-d H:i:s'),$row[6]);

            if($checkResellerRecharge > 0){
                dd($row[0]);
            }

            if($payment_method != "cash"){


                $resellerClientOlineRechargeService = new ResellerClientOlineRechargeService();
                $resellerClientOlineRechargeService->addOrUpdateBalanceResellerOrPop("reseller",$reseller_id,$amount);
                $after_amount = Balance::where('type', "reseller")
                        ->where('type_id', $reseller_id)
                        ->first()->amount;

                $actions = 'Manager recharge received from online client by ' . $client->name .' '. $payment_method. ' from '. $client->clientsinfo->clients_name ;




                ResellerRechargeReport::create([
                    'reseller_id'                       => $reseller_id,
                    'amount'                            => $amount,
                    'after_recharge_balance'            => $after_amount,
                    'remarks'                           => $actions ?? '',
                    'user_id'                           => $user_id,
                    'income_id'                         => null,
                    'paid_amount'                       => $amount,
                    'payment_type'                      => "online",
                    'payment_gateway'                   => $payment_method,
                    'payment_gateway_transaction_id'    => null,
                    'txn_id'                            => $trx_id,
                    'created_at'                        =>Carbon::parse($phpDate)->format('Y-m-d H:i:s')
                ]);
            }

            $paymentController = new PaymentController();
            $pop = Pop::with('reseller')->find($client->pop_id);
            $payment = Billpayment::find($row[0]);


            $resellerClientOlineRechargeService->addOrUpdateBalanceResellerOrPop("reseller",$reseller_id,-$amount);

            $after_amount = Balance::where('type', "reseller")
                    ->where('type_id', $reseller_id)
                    ->first()->amount;

            $created_by = 'Online Payment';

            $report = ReselleBalanceLogReport::create(
                [
                    'reseller_id' => $pop->reseller_id,
                    'client_id'   => $client->id,
                    'action'      => 'Bill payment from payment option payment id: ' . $payment->id,
                    'amount'      => $amount,
                    'remarks'     => 'Created BY ' . $created_by,
                    'uniqueId'    => createUUID(),
                    'pop_id'      => $client->pop_id,
                    'commission_amount' => getCommissionForResellerRecharge($client->id,$amount),
                    'created_at'    => Carbon::parse($phpDate)->format('Y-m-d H:i:s'),
                    'reseller_commission_percentage' => $pop->reseller->commission_percentage,
                    'pop_commission_percentage' => $pop->commission_percentage,
                ]
            );

            $payment->reseller_balance_deduct = $amount;
            $payment->reseller_balance_log_report = $report->id;
            $payment->save();

        }
    }
}
