<?php

namespace App\Console\Commands;

use App\Classes\SMS\ExpireCustomerNotifySms;
use App\Http\Controllers\CompanyInfoController;
use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Client;
use Illuminate\Console\Command;
use App\Jobs\ExpireCustomerNotification;
use App\Jobs\ResellerSendSms;
use App\Models\Reseller;
use App\Models\ResellerSmsGetway;
use App\Models\ResellerSmsLog;
use App\Models\SmsLog;
use App\Models\SmsPaymentReminder;
use Illuminate\Support\Facades\Log;

class ExpireSmsSendCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expire:notification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This Will send sms to expire customer';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

    public function getMessage($client, $sms)
    {
        $l = new CompanyInfoController();
        $link = $l->baseUrl();
        if ($client->customerAccount && $client->customerAccount->dueAmount > 0) {
            $dueAmount = $client->customerAccount->dueAmount;
        } else {
            $dueAmount = 0;
        }


        if (getBillingType() == 'day_to_day' || siteinfo()->day_to_day_after_10_days == 'Yes') {
            $check_due = isset($client->customerAccount) ? $client->customerAccount->dueAmount : 0;
            $dueAmount = ($client->packages->package_rate ?? 0)  + $check_due - ($client->parmanent_discount ?? 0);

        }
        Log::error($client->id);

            $message = $sms;

            $message = str_replace(
                [
                    '{c_id}',
                    '{c_code}',
                    '{c_username}',
                    '{c_name}',
                    '{c_password}',
                    '{c_deadline}',
                    '{MonthlyBill}',
                    '{TotalDue}',
                    '{company_name}',
                    '{company_cell}',
                    '{payment_url}',
                    '{BTRC_speed}',
                    '{BTRC_rate}'
                ],
                [
                    $client->id,
                    $client->customer_code ?? '',
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    $client->password,
                    Carbon::parse($client->expire_date)->format('d-M-Y'),
                    $client->packages->package_rate ?? 0,
                    $dueAmount,
                    siteinfo()->name,
                    siteinfo()->mobile,
                    $link.$client->slug,
                    $client->packages->package_bandwidth ?? 0,
                    $client->packages->btrc_package_price ?? 0
                ],
                $message
            );


            Log::error("Final Message for Client ID: " . $client->id . " is: " . $message);
        return $message;
    }




    public function handle()
    {
        // Log::info("log -expire:notification");

        if(globalPermission('customResellerSmsGatewaySetup')){

            $this->processWithSeparateGatewayOwnResellers();
        }else{
            $this->processWithDefaultGatewayOwnResellers();
        }


        $this->processWithSeparateGatewayOtherResellers();
    }

    protected function processWithSeparateGatewayOwnResellers()
    {
        $ownResellers = Reseller::with('resellerSmsGateway')
                ->where('reseller_type', 'own')
                ->whereHas('resellerSmsGateway', function($query) {
                    $query->whereNotNull('sms_gateway'); // Ensure that sms_gateway is present
                })->get();

            foreach ($ownResellers as $reseller) {
                $smsGateway = $reseller->resellerSmsGateway;

                if ($smsGateway->sms_gateway) {
                    // Decode and collect SMS format just once
                    $reminderCustomerSms = collect(json_decode($smsGateway->sms_formate))
                        ->where('sms_type', 'own_reseller_customer_reminder')
                        ->first();

                    // Check if we need to send SMS
                    if ($reminderCustomerSms && $reminderCustomerSms->send_sms === "Yes") {
                        // Logic for sending SMS goes here
                        $pop_ids = Pop::where('reseller_id',$reseller->id)
                                                         ->where('sms_send', 'yes')->pluck('id');

                        $clients = $this->getAllEligibleClientsToNotifyWithSms($pop_ids,$reminderCustomerSms->days_before);


                        $this->sendSmsClients($clients,$reminderCustomerSms->sms_body,$smsGateway->sms_gateway,$reseller->id);

                    }
                }
            }

    }

    protected function processWithDefaultGatewayOwnResellers()
    {
        $pops = Pop::where('bill_generate', 'yes')->where('sms_send', 'yes')->pluck('id');

            $sms = json_decode(getSmsMessage()->where('tamplate_name', 'bill_reminder')->first()->tamplate_body);

            if ($sms->frist_sendsms == 'Yes') {

                $clients = $this->getAllEligibleClientsToNotifyWithSms($pops,$sms->first_reminder_day);

                if ($clients->count() > 0) {

                    if (SmsPaymentReminder::where('expire_date', $clients->first()->expire_date)->where('step', 'first')->count() < 1) {

                        $client_ids = $clients->pluck('userid')->toJson();

                        SmsPaymentReminder::create([
                            'step' => 'first',
                            'expire_date' => $clients->first()->expire_date,
                            'user_list' => $client_ids
                        ]);


                        $this->sendSmsClients($clients,$sms->frist_sms_body);

                    }
                }
            }
    }

    protected function processWithSeparateGatewayOtherResellers()
    {
        $other_resellers_pops = Pop::where('bill_generate', 'no')->get();

        foreach ($other_resellers_pops as $pop) {
            $reseller_sms_getway = ResellerSmsGetway::with('reseller')->where('reseller_id', $pop->reseller_id)->first();
            if($reseller_sms_getway){
                $reminder_customer_sms = collect(json_decode($reseller_sms_getway->sms_formate))->where('sms_type','other_reseller_customer_reminder')->first();
                if($reminder_customer_sms->send_sms == "Yes"){
                    $notify_clients = Client::with('clientsinfo')->where('expire_date', today()->addDay($reminder_customer_sms->days_before))->where('pop_id', $pop->id)->get();
                    foreach($notify_clients as $item){
                        (new ExpireCustomerNotifySms)->otherResellerCustomerSendSmsBeforeExpire($item,$reseller_sms_getway->sms_gateway,$reseller_sms_getway->reseller->name,
                                                            $reseller_sms_getway->reseller->contact,$reminder_customer_sms->sms_body,$reseller_sms_getway->reseller->id);
                    }
                }
            }

        }
    }

    public function getAllEligibleClientsToNotifyWithSms($pop_ids, $days)
    {
        $clientsQuery = Client::with([
            'customerAccount',
            'packages:id,package_rate,package_bandwidth,btrc_package_price',
            'clientsinfo:id,client_id,contact_no,clients_name'
        ])
        ->whereIn('clients_status', ['active', 'expired', 'disable'])
        ->whereIn('pop_id', $pop_ids);

        if (getBillingType() != 'day_to_day') {
            $clientsQuery->whereHas('customerAccount', function ($q) {
                $q->where('dueAmount', '>', 0);
            });
        }

        // Handle first day of the month
        if (today()->format('d') == '01' && getBillingType() != 'day_to_day') {
            SmsPaymentReminder::where('expire_date', today()->format('Y-m-d'))->delete();
            $clientsQuery->where(function ($q) use ($days) {
                $q->where('expire_date', today())
                ->orWhere('expire_date', today()->addDay($days));
            });
        } else {
            $clientsQuery->where('expire_date', today()->addDay($days));
        }

        return $clientsQuery->select(
            'id', 'expire_date', 'clients_status', 'pop_id',
            'userid', 'password', 'slug', 'package_id', 'customer_code'
        )->get();
    }


    public function sendSmsClients($clients,$message,$resellerSmsGateway = null,$reseller_id = null){
        $billingType = getBillingType();
        $dayToDayAfter10Days = siteinfo()->day_to_day_after_10_days === 'Yes';
        $shouldCheckDueAmount = $billingType === 'day_to_day' || $dayToDayAfter10Days;

        foreach ($clients as $client) {
            Log::error($client->id." check this");
            // Cache the required client data
            // Calculate due amount
            $checkDue = $client->customerAccount->dueAmount ?? 0;
            $packageRate = $client->packages->package_rate ?? 0;
            $permanentDiscount = $client->parmanent_discount ?? 0;
            $dueAmount = $packageRate + $checkDue - $permanentDiscount;

            // Decide whether to send the notification based on dueAmount and global conditions
            if (!$shouldCheckDueAmount || $dueAmount > 0) {



                if($resellerSmsGateway == null){
                    $contactNo = $client->clientsinfo->contact_no;
                    $finalMessage = $this->getMessage($client, $message);

                    $data = [
                        'message' => $finalMessage,
                        'contact_no' => $contactNo,
                        'type' => 'reminder'
                    ];
                    ExpireCustomerNotification::dispatch($data);
                }else{
                    $contactNo = $client->clientsinfo->contact_no;
                    $finalMessage = $this->getMessage($client, $message);
                    $data = [
                        'reseller_id' => $reseller_id,
                        'contact' => $contactNo,
                        'message' => $finalMessage,
                        'type' => "Reminder",
                        'api' => $resellerSmsGateway

                    ];
                    ResellerSendSms::dispatch($data);
                }

            }
        }
    }


}
