<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Reseller;
use Illuminate\Http\Request;
use App\Models\SubResellerBalanceLogReport;

class SubResellerBalanceLogReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:sub-reseller-balance-log-report',['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $start = Carbon::now()->today();

        // dd($start);
        $end = today();
        return view('subresellerBalanceLog.index', [
            'page_title' => 'Sub-Manager Balance Log Report',
            'start'      => $start,
            'end'        => $end,
            'reseller'   =>  Reseller::resellerList()->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function subResellerBalanceLogReport(Request $request)
    {

        if ($request->ajax()) {

            //    dd($request->all());


            $from = $request->from_date == '' ? today() : Carbon::parse($request->from_date);
            $to   = $request->to_date == '' ? today() : Carbon::parse($request->to_date);

            // $resellerlist = Reseller::resellerList()->get();
            // $reseller_ids = $resellerlist->pluck('id')->toArray();

            $from = Carbon::parse($from)->format('Y-m-d 00:00:00');
            $to   = Carbon::parse($to)->format('Y-m-d 23:59:59');

            $poplist = Pop::conditionalList();
            $pop_ids = $poplist->pluck('id')->toArray();

            $list = SubResellerBalanceLogReport::with('user', 'client')
                                                ->whereBetween('created_at', [$from, $to]);


            if($request->username){
                $list->whereHas('client',function($q) use($request){
                    $q->where('userid','like','%'.$request->username.'%');
                });

            }

            if ($request->reseller == 'all') {
                $list->whereIn('sub_reseller_id', $pop_ids);
            } elseif ($request->pop == 'all') {

                $list->where('reseller_id', $request->reseller)
                    ->whereIn('sub_reseller_id', $pop_ids);
            } else {
                $list->where('reseller_id', $request->reseller)
                    ->where('sub_reseller_id', $request->pop);
            }


            return view('subresellerBalanceLog.result', [
                'list'       =>  $list->get(),
                'pops'       =>  $poplist
            ]);
        }
    }
}
