@extends('layout.app')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="#" id="search">
            <h4 class="p-2 border-l">Reseller Payment Report</h4>

            <div class="row">




                <div class="col-md-2 col-sm-4">
                    <div class="form-group">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select Manager</label>
                        <select name="reseller_id" id="reseller_id" class="select2 form-control">
                            <option value="">All Reseller</option>
                            @foreach ($reseller as $r)
                                <option value="{{ $r->id }}">{{ $r->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-md-2 col-sm-4">
                    <div class="form-group">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select Sub-Manager/Pop</label>
                        <select name="pop_id" id="pop" class="select2 form-control">
                            <option value="">All Pops/Sub-manager</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-2 col-sm-4">
                    <div class="form-group">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select Area</label>
                        <select name="area" id="area" class="select2 form-control">
                            <option value="">All Area</option>
                            @foreach ($areas as $area)
                                <option value="{{ $area }}">{{ $area }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-md-2 col-sm-4">
                    <div class="form-group">
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                            Expire Date
                        </label>
                        <div class="input-group date" id="searchTo" data-target-input="nearest">
                            <input type="text" name="expire_date"
                                class="form-control datetimepicker-input"
                                data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                        </div>
                    </div>
                </div>


                <div class="col-md-2 col-sm-4">
                    <div class="">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'></label>
                        <button type="submit" id="paymentSearch" class="btn btn-primary w-100 mt-2"><i class="fa fa-search"></i> Search</button>
                    </div>
                </div>


            </div>
        </form>

        <div id="loader" style="display: none; margin-top: 10px;">
            <i class="fa fa-spinner fa-spin"></i> Loading...
        </div>

        <div id="result" class="mt-4">
            @include('report.resellerClientAccount.dueReport.search')
        </div>
    </div>
</div>
@endsection

@section('ajax')
<script>
    $(function () {
        // Initialize select2
        $('.select2').select2();

        // Initialize datetime pickers (flatpickr or tempus dominus - use as per your setup)
        $('#searchFrom, #searchTo').datetimepicker({
            format: 'L'
        });

         // Populate pop list on reseller change
         $('#reseller_id').on('change', function () {
            $("#loader").show();
            $.ajax({
                type: 'GET',
                url: '{{ route('getPopForManager') }}',
                data: {
                    id: $(this).val()
                },
                success: function (data) {
                    $('#pop').empty().append(data);
                    $("#loader").hide();
                }
            });
        });

        // Handle search via AJAX
        $('#paymentSearch').on('click', function (e) {
            e.preventDefault();
            $("#loader").show();

            $.ajax({
                type: 'GET',
                url: '{{ route('resellerClientDueReportSearch') }}',
                data: $('#search').serialize(),
                success: function (result) {
                    $('#result').html(result);
                    $("#loader").hide();
                },
                error: function () {
                    $('#result').html('<div class="alert alert-danger">Something went wrong.</div>');
                    $("#loader").hide();
                }
            });
        });
    });
</script>
@endsection
