<?php

namespace App\Http\Controllers;

use App\Models\Box;
use App\Models\Reseller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BoxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('box.index',[
            'boxs' => Box::with('manager','pop')->paginate(20)
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('box.create',[
            'reseller'  => Reseller::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'manager_id'  => 'required',
            'pop_id'  => 'required',
            'box_name'  => 'required|unique:boxes',
        ]);
        // dd($request->all());
        $box = new Box();
        $box->manager_id = $request->manager_id;
        $box->pop_id = $request->pop_id;
        $box->box_name = $request->box_name;
        $box->save();

        return redirect()->route('box.create')->with('success_message', 'Information Added Successufll');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Box  $box
     * @return \Illuminate\Http\Response
     */
    public function show(Box $box)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Box  $box
     * @return \Illuminate\Http\Response
     */
    public function edit(Box $box)
    {
        return view('box.edit',[
            'box'   => $box,
            'reseller'  => Reseller::all()
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Box  $box
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Box $box)
    {
        $request->validate([
            'manager_id'  => 'required',
            'pop_id'  => 'required',
            'box_name'  => 'required|unique:boxes,box_name,'.$box->id,
        ]);
        // dd($request->all());
        $box = Box::find($box->id);
        $box->manager_id = $request->manager_id;
        $box->pop_id = $request->pop_id;
        $box->box_name = $request->box_name;
        $box->save();

        return redirect()->route('box.index')->with('success_message', 'Information Updated Successufll');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Box  $box
     * @return \Illuminate\Http\Response
     */
    public function destroy(Box $box)
    {
        //
    }
}
