<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;
    protected $fillable = [
        'name', 'bn_name', 'short_name','category_id' , 'unit_id','remarks','serial_number','alert_quantity'
    ];
    public function category(){

        return $this->belongsTo('App\Models\ItemCategory', 'category_id');

    }
    public function unit(){

        return $this->belongsTo('App\Models\Unit', 'unit_id');

    }

    public function serialNumbers()
    {
        return $this->hasMany(SerialNumber::class)->where('status',"notused");
    }

    public function stockIn()
    {
        return $this->hasMany(StockIn::class,'item_id');
    }

    public function stockOut()
    {
        return $this->hasMany(StockOut::class,'item_id');
    }

    public function itemReturn()
    {
        return $this->hasMany(ItemReturnItem::class,'item_id');
    }

    public function itemAdjustment()
    {
        return $this->hasMany(StockAdjustmentItem::class,'item_id');
    }
}
