const regex_coords = /\-?[0-9]+[\.]{0,1}[0-9]*/;

export default function validateCoordinate(number) {
  if (!number) return false;
  if (number.match(regex_coords) && !isNaN(Number(number))) {
    return true;
  } else {
    return false;
  }
}

export function createCoordinateObject(lat, long) {
  if (validateCoordinate(lat) && validateCoordinate(long)) {
    return { lat: Number(lat), lng: Number(long) };
  } else {
    return null;
  }
}
