<?php

use App\Http\Controllers\BankingController;
use App\Http\Controllers\BankTransfarController;
use Illuminate\Support\Facades\Route;

Route::resource('banking', BankingController::class);
Route::get('banking/approve/{id}', [BankingController::class, 'approve'])->name('banking.approve');

Route::get('bank/transfar', [BankTransfarController::class, 'index'])->name('bank.index');
Route::get('bank/transfar/export/excel', [BankTransfarController::class, 'exportExcel'])->name('bank.export.excel');
Route::get('bank/transfar/export/pdf', [BankTransfarController::class, 'exportPdf'])->name('bank.export.pdf');

Route::get('bank/diposit', [BankTransfarController::class, 'diposit'])->name('bank.diposit');
Route::post('bank/diposit', [BankTransfarController::class, 'dipositStore'])->name('bank.store.diposit');

Route::get('bank/withdraw', [BankTransfarController::class, 'withdraw'])->name('bank.withdraw');
Route::post('bank/withdraw', [BankTransfarController::class, 'withdrawStore'])->name('bank.store.withdraw');

Route::get('bank/transfar/{id}', [BankTransfarController::class, 'approve'])->name('bank.approve');
Route::get('bank/transfar/{id}/edit', [BankTransfarController::class, 'edit'])->name('bank.edit');
Route::post('bank/transfar/{id}/dipositupdate', [BankTransfarController::class, 'dipositupdate'])->name('bank.dipositupdate');
Route::post('bank/transfar/{id}/withdrawupdate', [BankTransfarController::class, 'withdrawupdate'])->name('bank.withdrawupdate');
Route::delete('bank/transfar/delete/{id}', [BankTransfarController::class, 'delete'])->name('bank.delete');
