<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Clients\IdDisconnectController;
use App\Models\Client;
use App\Models\User_log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DisableLimitOverUserController extends Controller
{
    public function disableLimitOverUser()
    {
        $clients = DB::select(
            'SELECT
                c.up_bandwidth AS "upload",
                c.down_bandwidth AS "download",
                COALESCE(c.bandwidth_limit, 0) AS "extraLimit",
                c.apply_bandwidth_limit AS "check",
                c.id AS "id",
                c.userid AS "userid",
                COALESCE(p.limite_quantity, 0) AS "totalLimit"
            FROM
                clients AS c
            LEFT JOIN
                packages AS p ON c.package_id = p.id
            LEFT JOIN
                pops ON pops.id = c.pop_id
            LEFT JOIN
                nas ON nas.id = pops.nas_id
            WHERE
                c.apply_bandwidth_limit = 0
                AND c.clients_status = "active"
                AND (COALESCE(c.up_bandwidth, 0) + COALESCE(c.down_bandwidth, 0)) > (COALESCE(c.bandwidth_limit, 0) + COALESCE(p.limite_quantity, 0))'
        );
        // dd($clients);

        foreach ($clients as $user) {
            echo $user->id . "\n";
            DB::beginTransaction();
            try {
                $details = "limit over";
                Client::where('id', $user->id)
                    ->update([
                        'clients_status' => 'disable'
                    ]);

                DB::table('radcheck')
                    ->whereUsername($user->userid)
                    ->update([
                        'op' => getBillingType() == 'day_to_day' ? '!=' : ':=',
                    ]);
                SessionRefreshController::userDisconnectProcess($user->userid);

                User_log::create([
                    'log_type' => 'id_disable',
                    'user_id' => 1,
                    'details' => $details,
                    'client_id' => $user->id
                ]);

                DB::commit();
            } catch (\Throwable $th) {

                DB::rollback();
                return 'error';
            }
        }
    }

    public function checkLimitCustomerAndProceed($client_id,$total_upload,$total_download,$extra_limit,$package_limit,$ignore)
    {
        $total_use = $total_upload + $total_download;
        $total_limit = $extra_limit + $package_limit;

        $check_id_enable = ($total_use <= $total_limit) || $ignore == 1;
        if($check_id_enable){
            $client = Client::find($client_id);
            $client->clients_status = 'active';
            $client->save();

            DB::table('radcheck')
            ->whereUsername($client->userid)
            ->update([
                'op' => ':='
            ]);

            User_log::create([
                'log_type' => 'id_enable',
                'user_id' => auth()->id(),
                'details' => "Client enable",
                'client_id' => $client->id
            ]);

        }
    }
}
