@extends('layout.app')
@php
    use Carbon\Carbon;
@endphp
@section('content')
    {{-- @dd($list) --}}
    @foreach ($list as $r)
        <div class="row">
            <div class="col-md-3">
                <div class="card ml-1">
                    <div class="card-body">
                        @if (checkSettings('profilePicture') == 'enable')
                            <div class="form-group col-sm-3">
                                @if ($r->profilePicture != null)
                                    @if (checkSettings('store_image_to_s3') == 'enable')
                                        @php
                                            $s3Url = Storage::disk('s3')->url(
                                                'customer_profile_picture/' . $r->customer_profile_picture,
                                            );
                                        @endphp

                                        <img width="150" height="150" style="border-radius: 50%" src="{{ $s3Url }}"
                                            alt="No Image">
                                    @else
                                        <img width="150" height="150" style="border-radius: 50%"
                                            src="{{ asset('storage/customer_profile_picture/' . $r->customer_profile_picture) }}"
                                            alt="No Image">
                                    @endif
                                @else
                                    <div
                                        style="background: #f0ede1;
                                    width: 200px;
                                    height: 200px;
                                    border-radius: 1%;">
                                    </div>
                                @endif
                            </div>
                            <label for="profilePicture" class="block pt-2">
                                Name : {{ $r->clients_name }}
                            </label>
                        @endif

                        <div class="card-header p-0 pt-1">
                            <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                                @can('show-service-information')
                                    <li class="nav-item">
                                        <a class="nav-link active" id="custom-tabs-one-auto-wellcome-sms-tab" data-toggle="pill"
                                            href="#custom-tabs-one-auto-wellcome-sms" role="tab"
                                            aria-controls="custom-tabs-one-auto-wellcome-sms" aria-selected="true">Service</a>
                                    </li>
                                @endcan
                                @can('show-personal-information')
                                    <li class="nav-item">
                                        <a class="nav-link" id="custom-tabs-one-bill-payment-tab" data-toggle="pill"
                                            href="#custom-tabs-one-bill-payment" role="tab"
                                            aria-controls="custom-tabs-one-bill-payment" aria-selected="false">Personal</a>
                                    </li>
                                @endcan
                                @can('show-address-information')
                                    <li class="nav-item">
                                        <a class="nav-link" id="custom-tabs-one-bill-address-tab" data-toggle="pill"
                                            href="#custom-tabs-one-bill-address" role="tab"
                                            aria-controls="custom-tabs-one-bill-address" aria-selected="false">Address</a>
                                    </li>
                                @endcan
                                @can('show-connection-information')
                                    <li class="nav-item">
                                        <a class="nav-link" id="custom-tabs-one-bill-connection-tab" data-toggle="pill"
                                            href="#custom-tabs-one-bill-connection" role="tab"
                                            aria-controls="custom-tabs-one-bill-connection" aria-selected="false">Connection</a>
                                    </li>
                                @endcan
                            </ul>
                        </div>
                        <div class="row mt-2 ml-1">
                            <div class="mr-2 mt-1">
                                <a href="{{ route('clients.index') }}" class="btn btn-default"><i
                                        class="fa fa-arrow-left"></i> Back</a>
                            </div>
                            <div class="mr-2 mt-1">
                                @if (checkSettings('show-traffice') == 'enable' && $r->client_approval != 'pending')
                                    <a class="btn btn-primary" id="speedshow">Show Speed</a>
                                @endif
                            </div>
                            {{-- <div class="mr-2 mt-1">
                                <button class="noprint btn btn-primary float-right mb-1" onclick="window.print()">
                                    <i class="fa fa-print"></i>
                                </button>
                            </div> --}}
                            <div class="mt-1">
                                @if ($customer_account > 0)
                                    @can('mac-customer_destroy')
                                        <form method="POST" action="{{ route('clients.destroy', $r->client_id) }}">
                                            @method('DELETE')
                                            @csrf
                                            <button style=""
                                                onclick="return confirm('Are you sure you want to Perform the Action?');"
                                                type="submit"class="btn btn-danger ">Delete</button>
                                        </form>
                                    @endcan
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="card ml-2">
                    <div class="card-body pl-2 ">
                        <div class="tab-content" id="custom-tabs-one-tabContent">
                            @can('show-service-information')
                                <div class="tab-pane fade show active" id="custom-tabs-one-auto-wellcome-sms" role="tabpanel"
                                    aria-labelledby="custom-tabs-one-auto-wellcome-sms-tab">
                                    <div class="container col-md-12">
                                        <div class="card-body">

                                            <div class="bg-primary">
                                                <h4 style="text-align: center;">Service Information</h4>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-borderd table-condensed">
                                                    <tr>
                                                        <td>Pop Name</td>
                                                        <td>{{ $r->popname }}</td>
                                                        <td>Billing Cycle</td>
                                                        <td>{{ $r->billing_cycle }}</td>
                                                    </tr>
                                                    <tr>
                                                        @if (!$r->isStatic)
                                                            <td>User Name</td>
                                                            <td>{{ $r->userid }}</td>
                                                        @else
                                                            <td>
                                                                IP Address
                                                            </td>
                                                            <td>
                                                                {{ $r->ip_address }}
                                                            </td>
                                                        @endif

                                                        @if (!$r->isStatic)
                                                            <td>Password</td>
                                                            <td>{{ $r->password }}</td>
                                                        @endif

                                                    </tr>
                                                    <tr>
                                                        <td>Package Name</td>
                                                        @if ($r->sub_package_name != null && $r->subreseller == 'yes')
                                                            <td>
                                                                {{ $r->sub_package_name }}
                                                                @can('show-mother-package')
                                                                    <br>
                                                                    {{ $r->package_name }}
                                                                @endcan
                                                            </td>
                                                        @else
                                                            <td>{{ $r->package_name }}</td>
                                                        @endif
                                                        <td>Expired Date</td>
                                                        <td> {{ $r->expire_date ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td> Enable MAC</td>
                                                        <td> {{ $r->mac ?? '' }}</td>
                                                        <td>Slug</td>
                                                        <td> {{ $r->slug ?? '' }}</td>
                                                    </tr>

                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endcan
                            @can('show-personal-information')
                                <div class="tab-pane fade" id="custom-tabs-one-bill-payment" role="tabpanel"
                                    aria-labelledby="custom-tabs-one-bill-payment-tab">
                                    <div class="container col-md-12">
                                        <div class="card-body">
                                            @if (checkSettings('profilePicture') == 'enable')
                                                <label for="">Customer Agrement : </label>
                                                @if (checkSettings('store_image_to_s3') == 'enable')
                                                    @php
                                                        $s3Url = Storage::disk('s3')->url(
                                                            'customer_agrement/' . $r->customer_agrement,
                                                        );
                                                    @endphp

                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ $s3Url }}" alt="No Image">
                                                @else
                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ asset('storage/customer_agrement/' . $r->customer_agrement) }}"
                                                        alt="No Image">
                                                @endif

                                                <label for="">Circle Form : </label>
                                                @if (checkSettings('store_image_to_s3') == 'enable')
                                                    @php
                                                        $s3Url = Storage::disk('s3')->url(
                                                            'profilePicture/' . $r->profilePicture,
                                                        );
                                                    @endphp

                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ $s3Url }}" alt="No Image">
                                                @else
                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ asset('storage/profilePicture/' . $r->profilePicture) }}"
                                                        alt="No Image">
                                                @endif
                                            @endif
                                            <div class="bg-primary">
                                                <h4 style="text-align: center;">Personal Information</h4>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-borderd table-condensed">
                                                    <tr>
                                                        <td> Client Name</td>
                                                        <td>{{ $r->clients_name }}</td>
                                                        <td>Date Of Birth</td>
                                                        <td>
                                                            @if ($r->dob)
                                                                {{ date('d-M-Y', strtotime($r->dob)) }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>Contact No</td>
                                                        <td>{{ $r->contact_no ?? '' }}</td>
                                                        <td>Email</td>
                                                        <td> {{ $r->email ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Father Name</td>
                                                        <td>{{ $r->father_name ?? '' }}</td>
                                                        <td>Mother Name</td>
                                                        <td> {{ $r->mother_name ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>National ID</td>
                                                        <td>{{ $r->national_id ?? '' }}</td>
                                                        <td> Passport No</td>
                                                        <td>{{ $r->passport_no ?? '' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endcan
                            @can('show-address-information')
                                <div class="tab-pane fade" id="custom-tabs-one-bill-address" role="tabpanel"
                                    aria-labelledby="custom-tabs-one-bill-address-tab">
                                    <div class="container col-md-12">
                                        <div class="card-body">
                                            @if (checkSettings('profilePicture') == 'enable')
                                                <label for="">Building Photo : </label>
                                                @if (checkSettings('store_image_to_s3') == 'enable')
                                                    @php
                                                        $s3Url = Storage::disk('s3')->url('picture/' . $r->picture);
                                                    @endphp

                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ $s3Url }}" alt="No Image">
                                                @else
                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ asset('storage/picture/' . $r->picture) }}" alt="No Image">
                                                @endif


                                                <label for="">Client Flat Door Picture : </label>
                                                @if (checkSettings('store_image_to_s3') == 'enable')
                                                    @php
                                                        $s3Url = Storage::disk('s3')->url(
                                                            'client_door/' . $r->client_door,
                                                        );
                                                    @endphp

                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ $s3Url }}" alt="No Image">
                                                @else
                                                    <img width="150" height="150" style="border-radius: 50%"
                                                        src="{{ asset('storage/client_door/' . $r->client_door) }}"
                                                        alt="No Image">
                                                @endif
                                            @endif
                                            <div class="bg-primary">
                                                <h4 style="text-align: center;">Address</h4>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-borderd table-condensed">
                                                    <tr>
                                                        <td>Road No</td>
                                                        <td>{{ $r->road_no ?? '' }}</td>
                                                        <td> Road Name</td>
                                                        <td>{{ $r->road_name ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td> Flat/Level No</td>
                                                        <td>{{ $r->flat_no ?? '' }}</td>
                                                        <td>Building No</td>
                                                        <td>{{ $r->building_no ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Building Name</td>
                                                        <td>{{ $r->building_name ?? '' }}</td>
                                                        <td>Block/Sector</td>
                                                        <td>{{ $r->block_sector ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Latitude</td>
                                                        <td>{{ $r->client_latitude ?? '' }}</td>
                                                        <td>Longitude</td>
                                                        <td>{{ $r->client_longitude ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td> Area</td>
                                                        <td>{{ $r->area ?? '' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endcan
                            @can('show-connection-information')
                                <div class="tab-pane fade" id="custom-tabs-one-bill-connection" role="tabpanel"
                                    aria-labelledby="custom-tabs-one-bill-connection-tab">
                                    <div class="container col-md-12">
                                        <div class="card-body">
                                            <div class="bg-primary">
                                                <h4 style="text-align: center;">Connection Info</h4>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-borderd table-condensed">
                                                    @if ($r->bill_generate == 'yes')
                                                        <tr>
                                                            <td>Cable type</td>
                                                            <td>{{ $r->cable_type ?? '' }}</td>
                                                            <td>Cable Length(Meter)</td>
                                                            <td>{{ $r->required_cable ?? '' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Cable ID</td>
                                                            <td>{{ $r->cable_id ?? '' }}</td>
                                                            <td>Cable Type(CAT5/CAT6)</td>
                                                            <td>{{ $r->cat_type ?? '' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Cable(CAT-5/CAT-6) Length(Meter)</td>
                                                            <td>{{ $r->cat_length ?? '' }}</td>
                                                            <td>ONU MAC/Pon No/Serial No</td>
                                                            <td>{{ $r->onu_serial ?? '' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>OLT No</td>
                                                            <td>{{ $r->olt_pon }}</td>
                                                            <td>OLT Card Slot Number </td>
                                                            <td>{{ $r->olt_no }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>PON Module Port No</td>
                                                            <td>{{ $r->pon_port }}</td>
                                                            <td>Box</td>
                                                            <td>{{ $r->box }}</td>
                                                        </tr>
                                                    @endif
                                                    <tr>
                                                        <td>Remote Access : {{ $r->remote_access == 'Yes' ? 'Yes' : 'No' }}
                                                        </td>
                                                        <td>Remote Access Username : {{ $r->remote_access_username ?? '' }}
                                                        </td>
                                                        <td>Remote Access Password : {{ $r->remote_access_password ?? '' }}
                                                        </td>
                                                        <td>Remote Access Port : {{ $r->remote_access_port ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Connection Date :</td>
                                                        <td>
                                                            <strong>CD:</strong>
                                                            {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}<br>
                                                            @if ($r->joinDate)
                                                                <strong>JD:</strong>
                                                                {{ date('d-M-Y', strtotime($r->joinDate)) }}
                                                            @endif
                                                        </td>
                                                        <td>Created By :</td>
                                                        <td>
                                                            @php
                                                                $user = App\Models\User::where(
                                                                    'id',
                                                                    $r->created_by,
                                                                )->first();
                                                            @endphp
                                                            {{ $user->name ?? '' }} -- {{ $user->mobile_number ?? '' }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>Source Name :</td>
                                                        <td>
                                                            @php
                                                                $source = App\Models\ClientSource::where(
                                                                    'id',
                                                                    $r->source_name,
                                                                )->first();
                                                            @endphp
                                                            {{ $source->name ?? '' }}
                                                        </td>
                                                        @if (auth()->user()->hasRole('Reseller Admin'))
                                                        @elseif(auth()->user()->hasRole('Sub Reseller'))
                                                        @else
                                                            <td>Marketed By</td>
                                                            @if ($r->marketed_by == 0)
                                                                <td>No Marketing</td>
                                                            @else
                                                                @php
                                                                    $m = App\Models\ClientReferer::where(
                                                                        'id',
                                                                        $r->marketed_by,
                                                                    )->first();
                                                                @endphp
                                                                <td>{{ $m->firstname ?? '' }} {{ $m->lastname ?? '' }}</td>
                                                                {{-- <td>{{ $r->clientReferer->firstname ?? '' }}</td> --}}
                                                            @endif
                                                        @endif
                                                    </tr>
                                                    @if (globalPermission('manage-line-man'))
                                                        <tr>
                                                            <td>Line Man :
                                                                {{ $r->line_man_id ? App\Models\Employee::where('id', $r->line_man_id)->first()->name : 'No Line Man' }}
                                                            </td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                        </tr>
                                                    @endif
                                                    <tr>
                                                        <td>Remarks</td>
                                                        <td>{{ $r->remarks ?? '' }}</td>

                                                        <td style="">
                                                            {{-- @can('new-customer-approve')
                                                                <x-Custom.Actionform
                                                                    href="{{ route('clinetApprove', $r->id) }}"
                                                                    formClass="approve" btnClass="btn btn-success btn-sm"
                                                                    submitValue="Approve" inputName="user_approve"
                                                                    inputId="{{ $r->id }}" />
                                                            @endcan --}}
                                                            @php($permissions = userPermissions())
                                                            @if (checkSettings('local-user-first-approve') == 'enable')
                                                                @if (in_array('local-user-first-approve', $permissions))
                                                                    @if ($r->first_approval == 'Pending')
                                                                        <form action="{{ route('firstApproveAllPending') }}"
                                                                            method="post" id="firstAllPendingApproveForm">
                                                                            @csrf
                                                                            @method('post')
                                                                            <input type="hidden" name="first_client_ids[]"
                                                                                id="first_client_ids"
                                                                                value="{{ $r->client_id }}">

                                                                            <button class="btn btn-primary"
                                                                                id="firstAllApprove"><i
                                                                                    class="fa fa-check"></i>Final
                                                                                Approve</button>
                                                                        </form>
                                                                    @endif
                                                                @elseif (in_array('new-customer-approve', $permissions))
                                                                    @if ($r->client_approval == 'pending')
                                                                        <form action="{{ route('approveAllPending') }}"
                                                                            method="post" id="allPendingApproveForm">
                                                                            @csrf
                                                                            @method('post')
                                                                            <input type="hidden" name="client_ids[]"
                                                                                id="client_ids" value="{{ $r->client_id }}">

                                                                            <button class="btn btn-success float-right"
                                                                                id="allApprove"><i class="fa fa-check"></i>
                                                                                Approve</button>
                                                                        </form>
                                                                    @endif
                                                                @endif
                                                            @else
                                                                @if (in_array('new-customer-approve', $permissions))
                                                                    @if ($r->client_approval == 'pending')
                                                                        <form action="{{ route('approveAllPending') }}"
                                                                            method="post" id="allPendingApproveForm">
                                                                            @csrf
                                                                            @method('post')
                                                                            <input type="hidden" name="client_ids[]"
                                                                                id="client_ids" value="{{ $r->client_id }}">

                                                                            <button class="btn btn-success float-right"
                                                                                id="allApprove"><i class="fa fa-check"></i>
                                                                                Approve</button>
                                                                        </form>
                                                                    @endif
                                                                @endif
                                                            @endif
                                                        </td>
                                                        <td>
                                                            {{-- @if ($customer_account > 0)
                                                            @can('mac-customer_destroy')
                                                                <form method="POST"
                                                                    action="{{ route('clients.destroy', $r->client_id) }}">
                                                                    @method('DELETE')
                                                                    @csrf
                                                                    <button style="margin-inline: -30px;margin-top: 8px;"
                                                                        onclick="return confirm('Are you sure you want to Perform the Action?');"
                                                                        type="submit"
                                                                        class="btn btn-danger btn-sm">Delete</button>
                                                                </form>
                                                            @endcan
                                                        @endif --}}
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-sm border-0" style="border-radius: 12px; overflow: hidden;">
            <div class="card-body p-3">
                @if (checkSettings('show-traffice') == 'enable' && $r->client_approval != 'pending')
                    <input type="hidden" id="user_Id" name="user_id" value="{{ $r->id }}">
                    <input type="hidden" id="admin_user_Id" name="admin_user_Id" value="{{ $user_id }}">
                    <div class='row'>
                        <div class="col-md-6 mb-3 mb-md-0" id="addcsnvaus">
                            <div class="bg-white rounded-lg p-3" style="box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                                <canvas id="myChart" style="max-height: 1000px;"></canvas>
                            </div>


                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center"
                                    style="width: 38px; height: 38px; margin-right: 10px;">
                                    <i class="fas fa-network-wired" style="font-size: 1rem;"></i>
                                </div>
                                <h5 class="font-weight-bold mb-0" style="color: #2c3e50; font-size: 1.2rem;">Session
                                    Details</h5>
                            </div>

                            <div class="session-info-container">
                                <div class="info-item mb-2 bg-light rounded"
                                    style="border-left: 3px solid #3498db; transition: all 0.3s ease; padding: 0.75rem;">
                                    <div class="d-flex align-items-center mb-1">
                                        <i class="fas fa-clock text-primary mr-2" style="font-size: 0.9rem;"></i>
                                        <span class="text-muted small font-weight-bold text-uppercase"
                                            style="font-size: 0.72rem; letter-spacing: 0.3px;">Last Link Up Time</span>
                                    </div>
                                    <div class="mt-1">
                                        <span class="text-dark font-weight-semibold" style="font-size: 0.95rem;">
                                            {{ $bandwidthUsage ? parseDate($bandwidthUsage['last-link-up-time']) : '-1' }}
                                        </span>
                                    </div>
                                </div>

                                <div class="info-item mb-2 bg-light rounded"
                                    style="border-left: 3px solid #e74c3c; transition: all 0.3s ease; padding: 0.75rem;">
                                    <div class="d-flex align-items-center mb-1">
                                        <i class="fas fa-sign-out-alt text-danger mr-2" style="font-size: 0.9rem;"></i>
                                        <span class="text-muted small font-weight-bold text-uppercase"
                                            style="font-size: 0.72rem; letter-spacing: 0.3px;">Last Logout Time</span>
                                    </div>
                                    <div class="mt-1">
                                        <span class="text-dark font-weight-semibold" style="font-size: 0.95rem;">
                                            {{ $lastLogoutTime ? parseDate($lastLogoutTime) : '-1' }}
                                        </span>
                                    </div>
                                </div>

                                <div class="info-item mb-2 bg-light rounded"
                                    style="border-left: 3px solid #9b59b6; transition: all 0.3s ease; padding: 0.75rem;">
                                    <div class="d-flex align-items-center mb-1">
                                        <i class="fas fa-fingerprint mr-2" style="color: #9b59b6; font-size: 0.9rem;"></i>
                                        <span class="text-muted small font-weight-bold text-uppercase"
                                            style="font-size: 0.72rem; letter-spacing: 0.3px;">Client Mac Address</span>
                                    </div>
                                    <div class="mt-1">
                                        <span class="text-dark font-weight-semibold font-monospace"
                                            style="font-size: 0.95rem;">
                                            {{ $activeClientInfo ? $activeClientInfo['caller-id'] : '-1' }}
                                        </span>
                                    </div>
                                </div>

                                <div class="info-item mb-2 bg-light rounded"
                                    style="border-left: 3px solid #27ae60; transition: all 0.3s ease; padding: 0.75rem;">
                                    <div class="d-flex align-items-center mb-1">
                                        <i class="fas fa-industry text-success mr-2" style="font-size: 0.9rem;"></i>
                                        <span class="text-muted small font-weight-bold text-uppercase"
                                            style="font-size: 0.72rem; letter-spacing: 0.3px;">Vendor Name</span>
                                    </div>
                                    <div class="mt-1">
                                        <span class="text-dark font-weight-semibold" style="font-size: 0.95rem;">
                                            {{ $vendorName ?? '-1' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3 mb-2">
                                <div class="col-6 pr-2">
                                    <div class="stat-card p-3 rounded text-center"
                                        style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);">
                                        <div class="d-flex align-items-center justify-content-center mb-2">
                                            <i class="fas fa-download text-white mr-2" style="font-size: 0.9rem;"></i>
                                            <span class="text-white-50 small font-weight-bold text-uppercase"
                                                style="font-size: 0.7rem;">Download</span>
                                        </div>
                                        <div class="text-white" style="font-size: 1.4rem; font-weight: 700;">
                                            {{ number_format(($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 0) / 1073741824, 2, '.', '') }}
                                            <span class="text-white-50"
                                                style="font-size: 0.85rem; font-weight: 500;">GB</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6 pl-2">
                                    <div class="stat-card p-3 rounded text-center"
                                        style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); box-shadow: 0 4px 12px rgba(245, 87, 108, 0.3);">
                                        <div class="d-flex align-items-center justify-content-center mb-2">
                                            <i class="fas fa-upload text-white mr-2" style="font-size: 0.9rem;"></i>
                                            <span class="text-white-50 small font-weight-bold text-uppercase"
                                                style="font-size: 0.7rem;">Upload</span>
                                        </div>
                                        <div class="text-white" style="font-size: 1.4rem; font-weight: 700;">
                                            {{ number_format(($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 0) / 1073741824, 2, '.', '') }}
                                            <span class="text-white-50"
                                                style="font-size: 0.85rem; font-weight: 500;">GB</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="bg-white rounded-lg p-3 mt-3" style="box-shadow: 0 2px 8px rgba(0,0,0,0.08);">
                                <canvas id="pieChart" style="max-height: 200px;"></canvas>
                            </div> --}}
                        </div>
                    </div>
                @endif
            </div>
        </div>
        @if (globalPermission('onu_information_laser'))
            @can('onu_information_laser')
                @isset($onuInfo->laser)
                    <div class="container-fluid mt-2">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card p-3">
                                    <h5 class="text-center">ONU Information</h5>
                                    <table class="table table-bordered table-sm">
                                        <tr>
                                            <td><strong>OLT:</strong></td>
                                            <td>{{ $onuInfo->oltaddress ?? '-' }} - {{ $onuInfo->oltName ?? '-' }}</td>
                                            <td><strong>ONU Id:</strong></td>
                                            <td>{{ $onuInfo->onuid ?? '-' }}</td>

                                        </tr>
                                        <tr>
                                            <td><strong>Power(Laser):</strong></td>
                                            <td><span class="text-bold text-green">{{ $onuInfo->laser ?? '-' }}</span></td>
                                            <td><strong>Update:</strong></td>
                                            <td>{{ isset($onuInfo->updated_at) ? Carbon::parse($onuInfo->updated_at)->format('d-m-Y h:i A') : '-' }}
                                            </td>

                                        </tr>
                                        <tr>
                                            <td><strong>PON ID, Vlan:</strong></td>
                                            <td>{{ $onuInfo->interface ?? '-' }}, {{ $onuInfo->Vlan ?? '-' }}</td>
                                            <td><strong>Device Mac:</strong></td>
                                            <td>{{ strtoupper(implode(':', str_split($onuInfo->mac ?? null, 2))) ?? '-' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endisset
            @endcan
        @endif
    @endforeach
@endsection

@section('ajax')
    <style>
        .info-item {
            transition: all 0.3s ease;
        }

        .info-item:hover {
            transform: translateX(5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1) !important;
            background-color: #f8f9fa !important;
        }

        .stat-card {
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .session-info-container .info-item {
            background-color: #f8f9fa;
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script>
        function create_UUID() {
            var dt = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = (dt + Math.random() * 16) % 16 | 0;
                dt = Math.floor(dt / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }

        const data = {
            labels: [],
            datasets: [{
                label: 'Downloads',
                backgroundColor: '#333C83',
                borderColor: '#333C83',
                data: [],
                tension: 0.3,


            }, {
                label: 'Uploads',
                backgroundColor: 'rgb(255, 99, 132)',
                borderColor: 'rgb(255, 99, 132)',
                data: [],
                tension: 0.3,


            }]
        };


        const config = {
            type: 'line',
            data: data,
            options: {
                scales: {
                    y: {
                        ticks: {
                            callback: function(value, index, ticks) {
                                return value > 1 ? value + 'Mb' : (value * 1024) + "Kb";
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        text: 'Real-Time Speed',
                        padding: {
                            top: 10,
                            bottom: 10
                        },
                        font: {
                            size: 15,

                        }
                    },
                    legend: {
                        labels: {
                            // This more specific font property overrides the global property
                            font: {
                                size: 12
                            }
                        }
                    }
                }
            }
        };

        const myChart = new Chart(
            document.getElementById('myChart'),
            config
        );

        let usageData = [1, 1];
        if (!('{{ $error }}'.length > 0)) {
            usageData = [
                ({{ ($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 1) / 1048576 }}).toFixed(3),
                ({{ ($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 1) / 1048576 }}).toFixed(3),
            ]
        }

        const pieChartData = {
            labels: [
                'Downloads',
                'Uploads',
            ],
            datasets: [{
                label: 'My First Dataset',
                data: usageData,
                backgroundColor: [
                    '#333C83',
                    'rgb(255, 99, 132)',
                ],
                hoverOffset: 4
            }]

        };

        const pieChartConfig = {
            type: 'doughnut',
            data: pieChartData,
        }

        const pieChart = new Chart(
            document.getElementById('pieChart'),
            pieChartConfig
        );

        $('#speedshow').click(function() {
            $('#speedshow').hide();
            const uuid = create_UUID();


            const currentTime = () => {
                const today = new Date();
                const time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
                return time;
            }

            const addData = (chart, download, upload) => {
                const time = currentTime();

                chart.data.datasets[0].label = download > 1 ? `Download ${download.toFixed(3)} Mbps` :
                    `Download ${(download *1024).toFixed(3)} Kbps`
                chart.data.datasets[1].label = upload > 1 ? `Upload ${upload.toFixed(3)} Mbps` :
                    `Upload ${(upload *1024).toFixed(3)} Kbps`

                chart.data.labels.push(time)
                chart.data.datasets[0].data.push(download);
                chart.data.datasets[1].data.push(upload)
                chart.update();

            }

            function removeData(chart) {
                chart.data.labels.shift();
                chart.data.datasets.forEach((dataset) => {
                    dataset.data.shift();
                });
                chart.update();
            }
            const pusher = new Pusher('{{ config('broadcasting.connections.pusher.key') }}', {
                cluster: '{{ config('broadcasting.connections.pusher.options.cluster') }}'
            });
            const user_id = $('#user_Id').val();
            const admin_user_id = $('#admin_user_Id').val();

            const channel = pusher.subscribe(uuid);

            channel.bind('my-event', function(data) {
                const speed = JSON.parse(JSON.parse(JSON.stringify(data)).message)[0];
                const upload = speed["rx-bits-per-second"] / 1048576;
                const download = speed["tx-bits-per-second"] / 1048576;

                if (myChart.data.datasets[0].data.length > 15) {
                    removeData(myChart);
                }
                addData(myChart, download, upload)

            });

            $(document).ready(function() {
                const user_id = $('#user_Id').val();
                const admin_user_id = $('#admin_user_Id').val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getSpeed') }}',
                    data: {
                        id: user_id,
                        uuid: uuid,

                    },
                    success: function(data) {
                        $('#speedshow').show();

                    },
                    error: function(request, error) {
                        toastr.error(request.responseText);
                        $('#speedshow').show();
                    }
                });
            });
        });
    </script>
@endsection
