<?php

namespace App\Jobs;

use App\Classes\MikrotikService\SyncWithMk;
use App\Http\Controllers\SessionRefreshController;
use App\Models\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ExpireRadiusUserJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $userids;
    public function __construct($userids)
    {
        $this->userids = $userids;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        foreach ($this->userids as $userid) {
            try{

            }catch(\Exception $e){
                Log::error($e->getMessage());
            }
            $client = Client::with('pop')->where('userid', $userid)->first();
            $disableStatus = (new SyncWithMk)->isDisable($client);
            if($disableStatus){
                SessionRefreshController::userDisconnectProcess($userid);
            }
        }



    }
}
