<?php
namespace App\Services;

use App\Http\Controllers\PaymentDeleteController;
use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\Clientsinfo;
use App\Models\OtcPaymentLog;
use App\Models\ResellerCommissionReference;

class PaymentDeleteService
{

  static function delete($payment_id)
    {
        $payment = Billpayment::with('user', 'income')->find($payment_id);
        $amount = floatval($payment->paid_amount) + floatval($payment->discount_amount);
        $paid_amount = floatval($payment->paid_amount);



        $reseller_commission = ResellerCommissionReference::where('bill_payment_id', $payment->id)->first();
        if ($reseller_commission && $reseller_commission->bill_payment_id != null) {
            $reseller_commission->actions = $reseller_commission->actions . " deleted";
            $reseller_commission->received_amount = 0;
            $reseller_commission->save();
        }

        $clientIdForThisBillDelete = PaymentDeleteController::deletePayment($payment, $amount, $paid_amount);

        if (checkSettings('otc_payment_with_generale_payment') == 'enable') {

            $checkOtcPayment = OtcPaymentLog::where('payment_id', $payment->id)->get();
            if (count($checkOtcPayment) > 0) {
                $clientInfo = Clientsinfo::where('client_id', $payment->client_id)->first();
                $clientInfo->otc_due = $clientInfo->otc;
                $clientInfo->save();
                OtcPaymentLog::where('client_id', $payment->client_id)->delete();
            }
        }
    }

}
