@extends('layout.app')


@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered ">
                <thead>
                    <tr>
                        <th class="text-center">
                            ID
                        </th>
                        <th class="text-center">
                            Name
                        </th>
                        <th class="text-center">
                            Contact
                        </th>
                        <th class="text-center">
                            Address
                        </th>
                        <th class="text-center">
                            Create Date
                        </th>
                        <th class="text-center">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>
                            <td class="text-center">
                                {{ $r->name }}
                            </td>
                            <td class="text-center">
                                {{ $r->contact_no }}
                            </td>
                            <td class="text-center">
                                {{ $r->address }}
                            </td>
                            <td class="text-center">
                                {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>
                            <td class="text-center">
                                <a href="{{ route('branch.edit', $r->id) }}">
                                    <button class="btn btn-success ">Edit</button>
                                </a>
                            </td>
                        </tr>

                    @endforeach

                    <!-- More items... -->
                </tbody>
            </table>
            </div>

            <div class="p-5">
                {{ $list->links() }}
            </div>
        </div>
    </div>





@endsection
