<?php

namespace App\Http\Controllers;

use App\Models\Billpayment;
use App\Models\OtcPaymentLog;
use App\Models\Payment;
use Illuminate\Http\Request;

class OtcPaymentLogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OtcPaymentLog  $otcPaymentLog
     * @return \Illuminate\Http\Response
     */
    public function show(OtcPaymentLog $otcPaymentLog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OtcPaymentLog  $otcPaymentLog
     * @return \Illuminate\Http\Response
     */
    public function edit(OtcPaymentLog $otcPaymentLog)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OtcPaymentLog  $otcPaymentLog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, OtcPaymentLog $otcPaymentLog)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OtcPaymentLog  $otcPaymentLog
     * @return \Illuminate\Http\Response
     */
    public function destroy(OtcPaymentLog $otcPaymentLog)
    {
        //
    }


    public static function otcPaymentLog($client_id,$total_payment,$bill_id)
    {
        $payments = Billpayment::where('client_id',$client_id)->orderBy('id','desc')->get();

        foreach($payments as $payment){
            if($total_payment > 0){
                $this_payment = $payment->paid_amount;
                $this_payment_discount = $payment->discount_amount;

                $otcPayment = 0;
                $otcDiscount = 0;

                if($total_payment <= $this_payment){
                    $otcPayment = $total_payment;
                    $total_payment = $total_payment - $otcPayment;
                }else{
                    $otcPayment = $this_payment;
                    $total_payment = $total_payment - $otcPayment;
                }

                if($total_payment > 0){
                    if($total_payment <= $this_payment_discount){
                        $otcDiscount = $total_payment;
                        $total_payment = $total_payment - $otcPayment;
                    }else{
                        $otcDiscount = $this_payment_discount;
                        $total_payment = $total_payment - $otcPayment;
                    }
                }

                $otcPaymentLog = new OtcPaymentLog();
                $otcPaymentLog->client_id = $client_id;
                $otcPaymentLog->bill_id = $bill_id;
                $otcPaymentLog->payment_id = $payment->id;
                $otcPaymentLog->otc_payment = $otcPayment;
                $otcPaymentLog->otc_discount = $otcDiscount;
                $otcPaymentLog->otc_payment_date = $payment->created_at;
                $otcPaymentLog->employee_id = $payment->collected_by;
                $otcPaymentLog->admin_user_id = $payment->user_id;
                $otcPaymentLog->save();

            }
        }
    }
}
