<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class UserRedcheckUpdateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $lists;
    public function __construct($lists)
    {
        $this->lists = $lists;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {



        foreach ($this->lists as $l) {
            // dd("coems");
            echo 'process start for ' . $l->userid . '<br>';

            if ($l->clients_status == 'active' || $l->clients_status == 'disable' || $l->clients_status == 'expired') {

                DB::table('radcheck')->where('username', $l->userid)->delete();

                DB::table('radcheck')->insert([
                    'username' => $l->userid,
                    'attribute' => 'Cleartext-Password',
                    'op' => ':=',
                    'value' => $l->password
                ]);

                DB::table('radcheck')->insert([
                    'username' => $l->userid,
                    'attribute' => 'NAS-IP-Address',
                    'op' => ':=',
                    'value' => $l->nasname
                ]);
            } else {

                DB::table('radcheck')->where('username', $l->userid)->delete();
            }
        }
    }
}
