<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerDelInfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'deleted_by',
        'username',
    ];

    public function admin()
    {
        return $this->belongsTo(User::class, 'deleted_by', 'id');
    }
}