<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ClientsExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function headings(): array
    {
        return [
            'nameoperator',
            'typeofclient',
            'typeofconnection',
            'nameofclient',
            'distributionLocationpoint',
            'typeofconnectivity',
            'activationdate',
            'bandwidthallocationMB',
            'allowcateip',
            'houseno',
            'roadno',
            'area',
            'district',
            'thana',
            'clientphone',
            'mail',
            'sellingbandwidthBDTexcludingVAT'
        ];
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
       

        $items = [];
        foreach ($this->data as $client) {

            if ($client['clients_status'] === 'active') {
                $status = "Active";
            } else {
                $status = "Deactive";
            }


            $items[] = [
                $client->pop->popname,
                'local',
                $client->clientsinfo->cable_type ?? 'Fiber',
                $client->clientsinfo->clients_name,
                $client->clientsinfo->distribution_location ?? '',
                $client->clientsinfo->typeofconnectivity ?? '',
                $client->created_at ? date('Y-m-d',strtotime($client->created_at)) : '',
                $client->packages->package_rate ?? '',
                'Na',
                $client->clientsinfo->building_no ?? '',
                $client->clientsinfo->road_no ?? '',
                $client->clientsinfo->area ?? '',
                $client->clientsinfo->district ?? '',
                $client->clientsinfo->thana ?? '',
                $client->clientsinfo->contact_no ?? '',
                $client->clientsinfo->mail ?? '',
                'Na',
                'Na',
            ];

            // dd($items);

        }


        return collect($items);
    }
}
