@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="text-center">Please Enter New Bank Information</h4>
            <hr>
            <form action="{{ route('banking.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col-md-6 m-auto">
                        <div>
                            <label for="">Account's Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="account_name" placeholder="Account's Name">
                            @error('account_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Account No <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="account_no" placeholder="Account No">
                            @error('account_no')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Bank Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="bank_name" placeholder="Bank Name">
                            @error('bank_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="branch_name" placeholder="Branch Name">
                            @error('branch_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Status <span class="text-danger">*</span></label>
                            <select name="status" id="" class="form-control">
                                <option value="">Select Status</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                            @error('status')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Opening balance <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="opening_balance" placeholder="Opening balance">
                            @error('opening_balance')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <button class="btn btn-success mt-4" style="float: right">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
@endpush
