@extends('layout.app')

@push('styles')
    <link href="{{ asset('css/dashboard.css') }}" rel="stylesheet">
@endpush



@section('content')
    {{-- @include('dashboard.new.tokenSummary') --}}
    {{-- @include('dashboard.token') --}}
    @include('dashboard.new.barchart')
    @include('dashboard.new.counter')
    {{-- @include('dashboard.new.localApproxBill') --}}
    @hasrole('Admin')
        @can('dashboardLastPaymentReport')
            <div id="paymentReport">

            </div>
        @endcan
    @endhasrole

    {{-- @include('dashboard.new.paymentReport') --}}
    {{-- @include('dashboard.new.monthlyBillReport') --}}
    @include('dashboard.new.resellerWiseReport')
    {{-- @include('dashboard.new.monthlyBillReportPop') --}}
    @include('dashboard.new.popWiseReport')
    {{-- @include('dashboard.new.resellerRchargeReport') --}}
    @include('dashboard.new.resellerRchargeReportNew')

    @can('token-dashboard')
        <div id="tokenSection" class="col-md-12 text-center bg-white mb-2">
            <h2 class="text-center d-block mt-5">Token Summary</h2>
            <img src="{{ asset('/loader.gif') }}" width="100" alt="">
        </div>
    @endcan
    @include('dashboard.new.resellerCounter')

@endsection



{{-- get online user using ajax --}}
@section('ajax')
    <style>
        .tokenLink {
            cursor: pointer;
        }
    </style>
    <script>
        $(document).ready(function() {

            setTimeout(function() {
                $.ajax({
                    url: "{{ route('getOnlineUser') }}",
                    type: "GET",
                    success: function(data) {
                        // console.log(data);
                        $('#onlineUser').text(data.online);
                    }
                });
            }, 1000);




            setInterval(function() {
                $.ajax({
                    url: "{{ route('getOnlineUser') }}",
                    type: "GET",
                    success: function(data) {
                        $('#onlineUser').text(data.online);
                    }
                });
            }, 30000);


            // get token report after 2 second
            setTimeout(function() {
                $.ajax({
                    url: "{{ route('getTokenReport') }}",
                    type: "GET",
                    success: function(data) {
                        $('#tokenSection').html(data);
                    }
                });
            }, 1000);

            $(document).on('click', '.tokenLink', function() {
                window.location.href = "{{ route('searchToken') }}";
            });
             $(document).on('click','#tokenSummary',function(){
                window.location.href = "{{ route('token-report-summary') }}";
            });
            setTimeout(function() {
                $.ajax({
                    url: "{{ route('getPaymentReport') }}",
                    type: "GET",
                    success: function(data) {
                        console.log(data);
                        $('#paymentReport').html(data);
                    }
                });
            }, 1000);


        });
    </script>
@endsection
