import { useState } from 'react';
import { Button, Form } from 'react-bootstrap';
import { toast } from 'react-hot-toast';
import { useDispatch } from 'react-redux';
import { addOnuToCluster } from '../../../../../../store/asyncMethods/onuMethod';
import { setViewKey } from '../../../../../../store/reducers/currentClusterReducer';

const AddOnu = () => {
    const dispatch = useDispatch();
    const [onuData, onuSetData] = useState({
        name: '',
        serial_number: '',
        mac_address: '',
        manufactures: '',
        model: '',
        remarks: '',
    });

    const onChangeHandler = (e) => {
        onuSetData({ ...onuData, [e.target.name]: e.target.value });
    };

    const onSubmitHandler = async (e) => {
        e.preventDefault();
        dispatch(
            addOnuToCluster(onuData, () => {
                dispatch(setViewKey('view'));
                toast.success('Successfully Added Onu');
                onuSetData({
                    name: '',
                    serial_number: '',
                    mac_address: '',

                    manufactures: '',
                    model: '',
                    remarks: '',
                });
            })
        );
    };

    return (
        <Form onSubmit={onSubmitHandler}>
            <Form.Group className='mb-2'>
                <Form.Control
                    type='text'
                    placeholder='Onu Name'
                    name='name'
                    onChange={onChangeHandler}
                    value={onuData.name}
                />
            </Form.Group>{' '}
            <Form.Group className='mb-2'>
                <Form.Control
                    type='text'
                    placeholder='Manufactures'
                    name='manufactures'
                    onChange={onChangeHandler}
                    value={onuData.manufactures}
                />
            </Form.Group>
            <Form.Group className='mb-2'>
                <Form.Control
                    type='text'
                    placeholder='Mac Address'
                    name='mac_address'
                    onChange={onChangeHandler}
                    value={onuData.mac_address}
                />
            </Form.Group>
            <Form.Group className='mb-2'>
                <Form.Control
                    type='text'
                    placeholder='Serial Number'
                    name='serial_number'
                    onChange={onChangeHandler}
                    value={onuData.serial_number}
                />
            </Form.Group>
            <Form.Group className='mb-2'>
                <Form.Control
                    type='text'
                    placeholder='Model'
                    name='model'
                    onChange={onChangeHandler}
                    value={onuData.model}
                />
            </Form.Group>
            <Form.Group className='mb-2'>
                <Form.Control
                    as='textarea'
                    placeholder='Remarks'
                    rows={3}
                    name='remarks'
                    onChange={onChangeHandler}
                    value={onuData.remarks}
                />
            </Form.Group>
            <Button type='submit'>Submit</Button>
        </Form>
    );
};

export default AddOnu;
