import { createSlice } from '@reduxjs/toolkit';

const initialState = {
    cables: [],
};

const reducers = {
    setCables(state, action) {
        state.cables = action.payload;
        return state;
    },
    addCable(state, action) {
        state.cables.push(action.payload);
        return state;
    },

    removeCable(state, action) {
        const cableId = action.payload;
        state.cables = state.cables.filter((cable) => cable.id !== cableId);
        return state;
    },
};

const cableReducer = createSlice({
    name: 'cableReducer',
    initialState,
    reducers,
});

export const { setCables, addCable, removeCable } = cableReducer.actions;

export default cableReducer.reducer;
