@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">

        </div>
    </div>

    <div class="card" id="serarchReport">
        <div class="card-body">
            <p class="text-danger h3">Note: Those customers who already paid this month are not on this list.</p>
            <button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
            @php
                $totalRunningMonthDue = 0;
                $totalPreviousDue = 0;
            @endphp

            @foreach ($clients as $client)
                @php
                    $totalRunningMonthDue += $client->thisMonthBill->sum('bill_amount');
                    $totalPreviousDue += $client->customerAccount->dueAmount - $client->thisMonthBill->sum('bill_amount');
                @endphp
            @endforeach


                <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_client"> Total Row:
                    {{ $clients->count() }}</p>
                <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_amount">Total Runnign Month Due {{$totalRunningMonthDue}}
                    </p>
                <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_paid">Total Previous Due: {{$totalPreviousDue}}
                    </p>
                <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_due">Total Due: {{$totalPreviousDue + $totalRunningMonthDue}}

                </p>



                </div>
                <table class="table table-striped table-borderless table-condensed" id="result_table">
                    <thead>
                        <tr class="bg-black">

                            <th style="padding-left: 2px;padding-right: 2px;">Id</th>
                            <th style="padding-left: 2px;padding-right: 2px;">User Id</th>
                            <th style="padding-left: 2px;padding-right: 2px;">Status</th>
                            <th style="padding-left: 2px;padding-right: 2px;">Expire Date</th>
                            <th style="padding-left: 2px;padding-right: 2px; ">Clietn Name</th>
                            <th style="padding-left: 2px;padding-right: 2px; ">Mobile</th>
                            <th style="padding-left: 2px;padding-right: 2px; ">Runnign Month Due</th>
                            <th style="padding-left: 2px;padding-right: 2px; ">Previous Due</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- @dd($clients) --}}
                        @foreach ($clients as $client)
                                <td>{{$client->id}}</td>
                                <td>{{$client->userid}}</td>
                                <td>{{$client->clients_status }}</td>
                                <td>{{$client->expire_date}}</td>
                                <td>{{$client->clientsinfo->clients_name }}</td>
                                <td>{{$client->clientsinfo->contact_no }}</td>
                                <td>{{$client->thisMonthBill->sum('bill_amount') }}</td>
                                <td>{{ $client->customerAccount->dueAmount - $client->thisMonthBill->sum('bill_amount') }}</td>


                            </tr>
                        @endforeach
                        <tr class="text-bold">
                            <td colspan="6">Total</td>
                            <td >{{$totalRunningMonthDue}}</td>
                            <td >{{$totalPreviousDue}}</td>

                        </tr>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
@endsection




@section('ajax')
    <script type="text/javascript">


        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#result_table tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {

                    rowData.push(column.innerText.replace(/[\r\n]/gm, ' '));
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], {
                type: "text/csv"
            }));
            a.setAttribute("download", "runningMonthDue.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
@endsection

<style>
    .amount-container {
        flex-direction: column;
    }

    @media (min-width:640px) {
        .amount-container {
            flex-direction: row;
        }
    }
</style>
