<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientSummary;
use Illuminate\Http\Request;

class ClientSummaryController extends Controller
{
   public function storeClientSummary()
   {
        $monthYear = now()->format('M-Y');


        $clientCounts = [
            'total_clients' => Client::count(),
            'total_active_clients' => Client::where('clients_status', 'active')->count(),
            'total_expire_clients' => Client::where('clients_status', 'expired')->count(),
            'total_disable_clients' => Client::where('clients_status', 'disable')->count(),
            'total_de_active_clients' => Client::where('clients_status', 'deactive')->count(),
            'total_close_clients' => Client::onlyTrashed()->count(), // more elegant for deleted_at
        ];

        ClientSummary::updateOrCreate(
            ['month_year' => $monthYear],
            $clientCounts
        );

   }
}
