import React from "react";
import _ from "lodash";
import { useSelector } from "react-redux";
import { AiOutlineCaretRight } from "react-icons/ai";

import styles from "./SelectedNodes.module.css";

const SelectedNodes = () => {
    const { startNode, endNode } = useSelector(
        (state) => state.coordinatesReducer
    );

    return (
        <div className={styles.selectedNodes}>
            {startNode && (
                <span className="btn btn-sm btn-danger me-2">
                    Start Node <AiOutlineCaretRight className="mb-1" />{" "}
                    {startNode.name} ({_.toUpper(startNode.type)})
                </span>
            )}
            {endNode && (
                <span className="btn btn-sm btn-warning me-2">
                    End Node <AiOutlineCaretRight className="mb-1" />{" "}
                    {endNode.name} ({_.toUpper(endNode.type)})
                </span>
            )}
        </div>
    );
};

export default SelectedNodes;
