@extends('layout.app')


@section('content')
    <form action="{{ route('adjustment.store') }}" method="POST" id="itemReturnForm">

        @csrf
        <div class="card">
            <div class="card-body">
            <div class="row">
                <div class="form-group col-md-4">
                    <label for="supplier_id" class="">
                        Category
                    </label>

                    <select name="category_id" id="category_id" class="form-control select2">
                        <option value="">Select Category</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </select>

                </div>

                <div class="form-group col-md-4">
                    <label for="product_id" class="">
                        Item
                    </label>

                    <select name="product_id" id="product_id" class="form-control select2">
                        <option value="">Select Item</option>

                    </select>
                </div>
            </div>

                <div>

                    <button class="btn bg-primary float-right mb-2" id="addProduct">Add</button>
                </div>

                <div class="d-none mt-2" id="forTable">
                    <div class="row mt-2">

                        <div class="form-group col-md-6">
                            <label for="product_id" class=""> Reason </label>
                            <input type="text" class="form-control" id="reason" name="reason" required autocomplete="off">
                        </div>

                        <div class="form-group col-md-3">
                            <label for="supplier_id" class="">
                                Adjustment Type
                            </label>

                            <select name="type_id" id="type_id" class="form-control select2" required>
                                <option value="">Select Category</option>
                                @foreach ($adjustment_types as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>

                        </div>





                    </div>
                    <div class="table-responsive">
                    <table id="tableId" class="table">
                        <thead>
                            <th>Name</th>
                            <th>Quantity</th>
                            <th>Serial Number</th>
                            <th>Action</th>
                        </thead>
                        <tbody>
                            <tr style="display: none">
                                <td>
                                    <input type="text" data-role="tagsinput">
                                </td>
                                <td>
                                    <input type="text" data-role="tagsinput">
                                </td>
                                <td>
                                    <input class="serialNumber" type="text" data-role="tagsinput">
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                    <button class="btn bg-info float-right" id="saveBtn">Save</button>
                </div>


            </div>
        </div>
    </form>
@endsection
@push('js')
    {{-- <link rel="stylesheet" href="{{ asset('/')}}css/toastr.min.css"> --}}
    <link rel="stylesheet" type="text/css" href="{{ asset('/') }}css/tagsinput.css" crossorigin="anonymous"
        referrerpolicy="no-referrer">
    {{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" integrity="sha512-xmGTNt20S0t62wHLmQec2DauG9T+owP9e6VU8GigI0anN7OXLip9i7IwEhelasml2osdxX71XcYm6BQunTQeQg==" crossorigin="anonymous" referrerpolicy="no-referrer" /> --}}
    <style type="text/css">
        .bootstrap-tagsinput {
            width: 100%;
        }

        .label-info {
            background-color: #17a2b8;
        }

        .label {
            display: inline-block;
            padding: .25em .4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out,
                border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

    </style>
    <script src="{{ asset('/') }}js/tagsinput.js"></script>
    <script src="{{ asset('/') }}js/jquery.validate.js"></script>
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js" integrity="sha512-VvWznBcyBJK71YKEKDMpZ0pCVxjNuKwApp4zLF3ul+CiflQi6aIJR+aZCP/qWsoFBA28avL5T5HA+RE+zrGQYg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script> --}}

    <script>
        $(document).ready(function() {

            $('#saveBtn').click(function(e) {
                lessCheck = 0;
                $("tr .qty").each(function(index, value) {
                    currentqty = parseFloat($(this).val());
                    var serialNumber = $(this).parents("tr").find("input.serialNumber").val();
                    myArray = serialNumber.split(",");
                    if (currentqty < myArray.length) {
                        lessCheck = 1;
                        // console.log('comes');
                    }
                });
                e.preventDefault();
                if (lessCheck == 0) {
                    $('#itemReturnForm').valid();
                    $('#itemReturnForm').submit();
                } else {
                    toastr.error("Please do not Add Serial Number more than quantity");

                }
                // $('#itemReturnForm').submit();
            });

            $("#tableId").on("click", "#btnCancle", function() {
                $(this).closest("tr").remove();
            });

            $('#addProduct').on('click', function(e) {
                e.preventDefault();
                product = $('#product_id').val();
                var productName = $('#product_id').find(":selected").text();
                $('.serialNumber').tagsinput('refresh');
                if (product) {
                    $('#forTable').removeClass("d-none");
                    check = 0;
                    $("tr .productId").each(function(index, value) {
                        currentId = parseFloat($(this).val());
                        if (currentId == product) {
                            check = 1;
                        }

                    });
                    if (check == 0) {

                        $('#tableId tbody').append('<tr >' +
                            '<td style="padding-left: 2px "> ' + productName +
                            ' <input style="width: 80px" min=0 class="productId" value="' + product +
                            '"  type="hidden"  name="productId[]" step=".0001" required></td>' +
                            '<td style="padding-left: 2px; align: center"><input class="qty" value="" type="number"  name="qty[]" min=0 required autocomplete="off"> </td>' +
                            '<td ><input style="width: 100px" class="serialNumber" type="text" data-role="tagsinput" name="serialNumber[]" autocomplete="off"> </td>' +
                            '<td ><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-danger ">-</lable></td>' +
                            +'</tr>'
                        );
                        $('.serialNumber').tagsinput('refresh');

                    } else {
                        toastr.info("Product allready added");
                    }

                }
            });

            $('#category_id').change(function() {
                var id = $('#category_id').val();

                $.ajax({
                    url: "{{ route('get-item') }}",
                    type: 'get',
                    data: {
                        data: id
                    },
                    success: function(result) {
                        $('#product_id').find('option').remove().end().append(
                            '<option value="">Select Item</option>');

                        $.each(result, function(key, value) {
                            $("#product_id").append('<option value=' + value.id + '>' +
                                value.name + '</option>');
                        });
                    }
                });
            });

            $('#itemReturnForm').on('keydown', 'input', function(event) {

                if (event.which == 13) {
                    event.preventDefault();

                }

            });

        });
    </script>
@endpush
