@extends('layout.app')


@section('content')



    <div class="mt-2 card">
        <div class=" card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="text-center">
                            ID
                        </th>
                        <th class="text-center">
                            Name
                        </th>
                        <th class="text-center">
                            Email
                        </th>
                        <th class="text-center">
                            Mobile
                        </th>
                        <th class="text-center">
                            Create Date
                        </th>
                        <th class="text-center">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>
                            <td class="text-center">
                                {{ $r->name }}
                            </td>
                            <td class="text-center">
                                {{ $r->email }}
                            </td>
                            <td class="text-center">
                                {{ $r->mobile }}
                            </td>

                            <td class="text-center">
                                {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>
                            <td class="text-center">
                                @can('supplier_edit')
                                    <a href="{{ route('supplier.edit', $r->id) }}">
                                        <button class="btn btn-success">Edit</button></a>

                                @endcan
                            </td>
                        </tr>

                    @endforeach

                    <!-- More items... -->
                </tbody>
            </table>
            </div>
            <div class="p-5">
                {{ $list->links() }}
            </div>
        </div>
    </div>


@endsection
