<?php $__env->startSection('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Income List</h3>
                            <div class="card-tools">


                                


                                <a href="<?php echo e(route('income-head.create')); ?>"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Income
                                        Type</button></a>


                                <a href="<?php echo e(route('income.create')); ?>"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Income</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            
                                            <th>Name</th>
                                            <th>Income Head</th>
                                            <th>Invoice Number</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Bank Account</th>
                                            <th>Documents</th>
                                            <th>Description</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($row->id); ?></td>
                                                
                                                <td><?php echo e($row->name); ?></td>
                                                <td><?php echo e($row->head->name ?? ''); ?></td>
                                                <td><?php echo e($row->invoice_number); ?></td>
                                                <td><?php echo e($row->date); ?></td>
                                                <td><?php echo e($row->amount); ?></td>
                                                <td>
                                                    <?php if($row->bankAccount): ?>
                                                        <span class="badge badge-info">
                                                            <?php echo e($row->bankAccount->account_name); ?> - <?php echo e($row->bankAccount->bank_name); ?>

                                                        </span>
                                                    
                                                    <?php endif; ?>
                                                </td>
                                                <td>

                                                   <?php if(!empty($row->attach_document)): ?>
                                                        <?php
                                                            $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                                            $imgUrl = $isS3
                                                                ? $row->attach_document // already full URL from S3
                                                                : asset('storage/attachDocument/' . $row->attach_document); // local path
                                                        ?>

                                                        <img src="<?php echo e($imgUrl); ?>" width="auto" height="100" alt="Document">
                                                    <?php else: ?>
                                                        <p style="margin-inline: 10px">No File</p>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($row->description); ?></td>

                                                <td>
                                                    <?php if(!in_array($row->incomeHead, [1, 2, 3, 4, 5])): ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income-section')): ?>
                                                            <div class="btn-group">
                                                                <a href="<?php echo e(route('income.edit', $row->id)); ?>"
                                                                    class="btn btn-sm btn-primary">
                                                                    <i class="fa fa-edit"></i>
                                                                </a>
                                                            </div>
                                                            <div class="btn-group">
                                                                <a href="<?php echo e(route('editLog-history', ['id' => $row->id, 'type' => 'Income'])); ?>"
                                                                    class="btn btn-sm btn-primary">History</a>
                                                            </div>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income-destroy')): ?>
                                                                <div class="btn-group">
                                                                    <form action="<?php echo e(route('income.destroy', $row)); ?>"
                                                                        method="POST">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('DELETE'); ?>
                                                                        <button id="<?php echo e($row->id); ?>"
                                                                            class="btn btn-sm btn-danger">Delete</button>
                                                                    </form>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer">
                                <?php echo e($incomes->links()); ?>

                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                </div>
            </div>
            <!-- /.row -->



        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <!-- DataTables -->
    <script src="<?php echo e(asset('admin/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <!-- page script -->
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/crp/radius-circle/resources/views/accounts/income/index.blade.php ENDPATH**/ ?>