<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-light-primary elevation-2 ">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="user-panel  mb-2 pb-3 d-flex hidden " style="">
            <div class="image mt-2">
                @if (!empty(siteinfo()))
                    <img class="mt-1" width="auto" height="50"
                        src="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}" alt=""
                        class="profile-image">
                @endif
            </div>
            <div class="info mt-2 companyTitleName">
                @if (!empty(siteinfo()))
                    <a href="#" class="mt-2 d-block "
                        style=" font-size:x-large; text-transform: capitalize; letter-spacing: 1px;">{{ Str::limit(siteinfo()->name, 20) ?? '' }}</a>
                @endif
            </div>
        </div>


        <!-- Sidebar Menu -->
        <nav class="mt-2" style="overflow-y: scroll; max-height:800px; overflow-x:hidden;">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                @if (Auth::user()->hasRole('Admin'))
                    @can('portal-invoice')
                        <li
                            class="nav-item {{ request()->routeIs(['portal-invoice*', 'portal-invoice/new']) ? 'menu-open' : '' }}">
                            <a href="{{ route('portal-invoice') }}" class="nav-link"><i
                                    class="fas fa-dollar-sign nav-icon"></i>
                                <p>Billing Fix Bill</p>
                            </a>
                        </li>
                    @endcan
                @endif



                @cannot('specific_management_services')
                    <li class="nav-item {{ request()->routeIs(['dashboard*', 'dashboard/new']) ? 'menu-open' : '' }}">
                        <a href="{{ route('dashboard') }}" class="nav-link"><i class="fas fa-border-all nav-icon"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                @endcannot

                @can('network-manage')
                    @if (globalPermission('manage-map'))
                        <li class="nav-item">
                            <a href="{{ route('map') }}" class="nav-link"><i class="fas fa-border-all nav-icon"></i>
                                <p>Network Map</p>
                            </a>
                        </li>
                    @endif
                @endcan

                @if (checkSettings('Bank') == 'enable' && Auth::user()->can('bank'))
                    @include('layout.leftsidebar.bank')
                @endif


                @can('notification-setting')
                    @if (checkSettings('notification') == 'enable')
                        <li class="nav-item {{ request()->routeIs(['notification*']) ? 'menu-open' : '' }}">
                            <a href="#" class="nav-link">
                                <i class="fas fa-bell nav-icon"></i>
                                <p>
                                    Notifications
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="#" {{-- class="nav-link {{ request()->routeIs(['sms-gateway.index']) ? 'active' : '' }}" --}} class="nav-link ">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Notification Settings</p>
                                    </a>
                                </li>
                            </ul>

                        </li>
                    @endif
                @endcan

                @include('layout.leftsidebar.sms_setting')
                @include('layout.leftsidebar.email_setting')

                @if (checksettings('voice_message_send') == 'enable')
                    @include('layout.leftsidebar.voice_broadcast')
                @endif

                @hasanyrole('Admin|Billing Man')
                    <li class="nav-item">
                        <a href="{{ route('view_user_account_history', auth()->user()->id) }}"
                            class="nav-link {{ request()->routeIs(['view_user_account_history']) ? 'open' : '' }}"><i
                                class="fas fa-file-invoice nav-icon"></i>
                            <p>Accounts History</p>
                        </a>
                    </li>
                @endunlessrole




                @include('layout.leftsidebar.settings_section')


                @cannot('specific_management_services')
                    @include('layout.leftsidebar.customer')
                @endcannot
                @if (checksettings('CRM') == 'enable')
                    @include('layout.leftsidebar.crm')
                @endif


                @can('customer-support')
                    @include('layout.leftsidebar.support')
                @endcan

                @can('money-receipt-entry')
                    @include('layout.leftsidebar.account')
                @endcan


                @cannot('specific_management_services')
                    @include('layout.leftsidebar.report')
                @endcannot



                @include('layout.leftsidebar.store')

                @if (checkSettings('Bandwidth-section') == 'enable')
                    @can('bandwidth-buy')
                        <li
                            class="nav-item {{ request()->routeIs(['band-provider.*', 'band-service.*', 'band-purchase.*', 'bandwidthReport']) ? 'menu-open' : '' }}">
                            <a href="#" class="nav-link">
                                <i class="fas fa-bell nav-icon"></i>
                                <p>
                                    Bandwidth Buy
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">

                                <li class="nav-item">
                                    <a href="{{ route('band-provider.index') }}"
                                        class="nav-link {{ request()->routeIs(['band-provider.index']) ? 'active' : '' }}">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Provider</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{ route('band-service.index') }}"
                                        class="nav-link {{ request()->routeIs(['band-service.index']) ? 'active' : '' }}">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Service</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{ route('band-purchase.index') }}"
                                        class="nav-link {{ request()->routeIs(['band-purchase.index']) ? 'active' : '' }}">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Purchase Bill</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{ route('bandwidthReport') }}"
                                        class="nav-link {{ request()->routeIs(['bandwidthReport']) ? 'active' : '' }}">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Purchase Report</p>
                                    </a>
                                </li>

                            </ul>
                        </li>
                    @endcan
                    @can('bandwidth-sale')
                        @include('layout.leftsidebar.bwsale')
                    @endcan
                @endif

                @if (checkSettings('payroll') == 'enable' && Auth::user()->can('payroll'))
                    @include('layout.leftsidebar.payroll')
                @endif

                @include('layout.leftsidebar.admin')


                @if (checkSettings('help') == 'enable')
                    <li class="nav-item">
                        <a href="{{ route('help.index') }}" class="nav-link">
                            <i class="fa fa-question-circle nav-icon" aria-hidden="true"></i>
                            <p>Help</p>
                        </a>
                    </li>
                @endif

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>


<style>
    .sidebar nav::-webkit-scrollbar {
        width: 5px;
    }


    .sidebar nav::-webkit-scrollbar-track {
        background: #f1f1f1;
    }


    .sidebar nav::-webkit-scrollbar-thumb {
        background: #888;
    }


    .sidebar nav::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
</style>
