<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientImportAmountReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_import_amount_reports', function (Blueprint $table) {
            $table->id();
            $table->integer('reseller_id');
            $table->integer('pop_id');
            $table->integer('client_id');
            $table->string('package_name');
            $table->integer('package_id');
            $table->integer('sub_package_id')->nullable();
            $table->string('sub_package_name')->nullable();
            $table->integer('total_days');
            $table->integer('due_amount');
            $table->integer('sub_due_amount')->nullable();
            $table->integer('package_amount');
            $table->integer('sub_package_amount')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_import_amount_reports');
    }
}
