<?php

namespace App\Http\Controllers;

use App\Jobs\BillGenerateUpdateJob;
use App\Models\Client;
use App\Models\CustomerAccount;
use Illuminate\Http\Request;
use App\Services\ClientServices;
use Illuminate\Support\Facades\DB;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;

class BillCollectionController extends Controller
{
    public function billCollection()
    {
        $list = ClientServices::customerList('generateBill');

        return view('billing.pendingBill',[
            'page_title' => 'Customer Bill Collection List',
            'list' => $list->get()
        ]);
    }

    public function customerAccountFix()
    {

       $client_list =  DB::table('customer_accounts')
       ->whereRaw('totalPaid+totalDiscount+dueAmount!=totalBillAmount')
       ->where('dueAmount','>',0)
       ->get()
       ->map(function($item){
        $item->bill = DB::table('bill_generates')->where('client_id',$item->client_id)->selectRaw('sum(bill_amount) as totalBillAmount')->first()->totalBillAmount;
        return $item;
       })
       ->map(function($item){
        $item->payment = DB::table('bill_payments')->where('client_id',$item->client_id)->selectRaw('sum(paid_amount)+sum(discount_amount) as totalPaid')->first()->totalPaid;
        return $item;
       })
       ->map(function($item){
        $item->amount = DB::table('customer_balance_adjustment')->where('client_id',$item->client_id)->selectRaw('sum(amount) as amount')->first()->amount;
        return $item;
       })
       ->map(function($item){
        $item->due = $item->bill - $item->payment - $item->amount;
        return $item;
       });

       dd($client_list);

    }

    public function setPaidAmountToBillGenerate()
    {
        $clients = Client::withTrashed()->with('generatedBill','paymentBill','customerAccountAdjustment')->chunk(1000, function($clients){
               
                BillGenerateUpdateJob::dispatch($clients);
            }
        );



        Toastr::success('All Customer bill generate Successfully updated', 'Success');
        return back();
    }

    function fixedDueZeroCustomerAccount()
    {
        DB::beginTransaction();
        try{
            $start = today()->startOfMonth();
            $end =  today()->endOfMonth();
            $clients = Client::with('customerAccount')->whereHas('generatedBill', function ($query) use($start,$end){
                $query->where('billing_type', 'monthly')->whereBetween('created_at',[$start,$end]);
            })->whereHas('customerAccount', function ($query) {
                $query->where('dueAmount','<=', 0);
            })->whereBetween('expire_date',[$start,$end])->get();
            foreach($clients as $client){
                Client::where('id',$client->id)->update(['expire_date' => Carbon::parse($client->expire_date)->addMonth(),'clients_status'=>"active"]);
            }
            DB::commit();
            Toastr::success('All Customer expire date Successfully updated', 'Success');
            return redirect()->back();
        }catch(\Exception $e){
            Toastr::error('Something went wrong', 'Error');
            return redirect()->back();
        }

    }






}
