<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav justify-content-around align-items-center topFixed ">
        <li class="nav-items toggler-button">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button">
                <img src="<?php echo e(asset('images/others/bar.svg')); ?>" width="20px" alt="notification icon">
            </a>
        </li>
        <li class=" ml-lg-5 ">
            <div class="form-row">
                <div class="col-md-12">
                    <div class="input-group rounded mt-1 userSearchWrapper" style="text-align: left">
                        <img src="<?php echo e(asset('/images/others/search.svg')); ?>" alt="">
                        <input type="text" id="userSearch" name="id" class="form-control rounded border-none"
                            placeholder=" Username" style="width:250px" />


                    </div>
                </div>
                <div class="col-md-12" id="list">

                </div>
            </div>
        </li>

        <li class="nav-tiem dropdown d-block  d-xl-none" id="toggleDropDown">

            <a class="nav-link btn m-1 " data-toggle="dropdown" href="#">
                <i class="fa-solid fa-circle-user icon-color " style="font-size:28px; color:rgb(201, 121, 17);"></i>

            </a>

            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right " id="toggler">


                <div class="d-flex flex-column justify-content-between align-items-start py-3 ">

                    <div class="dropdown-item drop-border">
                        <div class="d-flex justify-content-start align-items-center" style="column-gap: 15px;">

                            <?php if(!empty(siteinfo())): ?>

                                <?php if(siteinfo()->img_url): ?>
                                    <div class="profile-image-container">
                                        <img src="<?php echo e(asset('storage/company/' . siteinfo()->img_url)); ?>" alt=""
                                            class="profile-image">
                                    </div>
                                <?php else: ?>
                                    <div class="profile-image d-flex justify-content-center align-items-center">
                                        <?php echo e(Str::substr(siteinfo()->name, 0, 2)); ?>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div>
                                <p style="text-transform: capitalize; font-size:18px; letter-spacing:0.05em;">
                                    <?php echo e(Str::limit(auth()->user()->name, '15')); ?></p>
                                <small><?php echo e(Auth::user()->getRoleNames()->first()); ?></small>
                            </div>
                        </div>
                    </div>

                    <a href="<?php echo e(route('user.edit', Auth::user()->id)); ?>" class="nav-link  dropdown-item"
                        role="menuitem">
                        <span style="text-transform: capitalize;"> <i
                                class="fa-solid fa-circle-user icon-color  mr-3"></i>
                            My Profile</span>
                    </a>

                    </a>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('password-change')): ?>
                        <a href="<?php echo e(route('passwordReset', Auth::user()->email)); ?>" class="nav-link  dropdown-item"
                            role="menuitem"><i class="fa fa-exchange-alt icon-color  mr-3"></i>Pasword Change</a>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('settings.create')); ?>" class="nav-link  dropdown-item" role="menuitem"><i
                            class="fa fa-cog icon-color mr-3"></i>Settings</a>
                    </a>

                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="nav-link dropdown-item text-start">
                        <?php echo csrf_field(); ?>
                        <i class="fa fa-sign-out-alt icon-color mr-2"></i>
                        <button type="submit" class="d-inline-block text-danger" id="logout-btn">Logout</button>
                        </a>
                    </form>
                </div>

            </div>
        </li>


    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto flex-wrap justify-content-between">


        <!-- Messages Dropdown Menu -->
        <li class="nav-item d-flex justify-content-center flex-wrap align-items-center " style="gap:2px !important;">

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mac-customer_create')): ?>
                <span class="nav-link border noted">
                    <a class="noted" href="<?php echo e(route('clients.create')); ?>">
                        Add Customer
                    </a>
                </span>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager-balance-on-topbar')): ?>
                <span class="nav-link border noted">
                    <a class="noted" href="<?php echo e(route('resellers.index')); ?>">
                        Balance: <?php echo e(managerBalance()); ?>

                    </a>
                    <span id="" class="text-success font-weight-bold"></span>
                </span>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub-manager-balance-on-topbar')): ?>
                <span class="nav-link border noted">
                    <a class="noted" href="<?php echo e(route('pop.index')); ?>">
                        Balance: <?php echo e(subManagerBalance()); ?>

                    </a>
                    <span id="" class="text-success font-weight-bold"></span>
                </span>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_commission_top_ber')): ?>
                <?php if(auth()->user()->hasRole(['Reseller Admin', 'Reseller'])): ?>
                    <span class="nav-link border noted">
                        <a class="noted" href="<?php echo e(route('resellers.index')); ?>">
                            Commission: <?php echo e(managerCommission()); ?>

                        </a>
                        <span id="" class="text-success font-weight-bold"></span>
                    </span>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(siteinfo()->online_offline_topbar == 'Yes'): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                    <a class="noted" href="<?php echo e(route('onlineCustomer')); ?>">
                        <span class="nav-link border noted">Online:
                            <span id="topbar_online_user" class="text-success font-weight-bold"></span>
                        </span>
                    </a>
                    <a class="noted" href="<?php echo e(route('oflineCustomer')); ?>">
                        <span class="nav-link border noted">Offline:
                            <span id="topbar_offline_user" class="text-danger font-weight-bold"></span>
                        </span>
                    </a>
                <?php endif; ?>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('radius_online_customer_reset')): ?>
                <?php if(!checkAPI()): ?>
                    <a href="<?php echo e(route('delete-radius-online-customer')); ?>" class="btn btn-danger mt-1">Delete Online
                        Customer</a>
                <?php endif; ?>
            <?php endif; ?>
            <?php if(checkAPI() == false): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('refresh')): ?>
                    <a class="nav-link border noted" href="<?php echo e(route('refresh_session')); ?>"
                        style="background: #14b8a6 !important; color:#FFFFFF;">
                        Refresh
                    </a>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(checkSettings('store') == 'enable'): ?>
                <?php if(auth()->check() && auth()->user()->hasAnyRole('Reseller Admin|Reseller|Sub Reseller')): ?>
                <?php else: ?>
                    <a class="nav-link border noted" href="<?php echo e(route('requisition.create')); ?>"
                        style="background: #ea580c !important; color:#FFFFFF;">
                        Requisition
                    </a>
                <?php endif; ?>
            <?php endif; ?>
            <?php if(checksettings('new-line-request') == 'enable'): ?>
                <span class="nav-link border d-flex align-items-center noted">
                    <a class="nav-link" href="<?php echo e(route('new-line-request.index')); ?>"style="padding: 8px;">
                        <i class="fa fa-plus-circle" aria-hidden="true" style="font-size: 25px"></i>
                        <span class="badge badge-danger navbar-badge text-light">
                                    <?php echo e(newClientRequestCount()); ?>

                                </span>
                    </a>
                </span>
            <?php endif; ?>


            <!-- Notifications Dropdown Menu -->
            <?php if(checkSettings('store') == 'enable'): ?>
                <?php if(auth()->check() && auth()->user()->hasRole('Admin|Store Manager')): ?>
                    <span class="nav-link border d-flex align-items-center noted">
                        <a class="nav-link" data-toggle="dropdown" href="#" data-toggle="tooltip"
                            data-placement="bottom" title="Stock Reminder ">

                            <img src="<?php echo e(asset('images/others/clock.svg')); ?>" alt="notification icon">
                            <span class="badge badge-warning navbar-badge text-light">
                                <?php echo e(\App\Classes\AvailableStockCalculation::stock_alert()); ?>

                            </span>
                        </a>
                    </span>
                <?php endif; ?>
            <?php endif; ?>

            <span class="nav-link border d-flex align-items-center noted">
                <a class="nav-link  m-1" data-toggle="dropdown" href="#">
                    <img src="<?php echo e(asset('images/others/notification.svg')); ?>" alt="notification icon">
                    <?php if(checkSettings('local-user-first-approve') == 'enable'): ?>
                        <span class="badge badge-warning navbar-badge text-light">
                            <?php echo e(\App\Services\ClientServices::customerList('pendingCustomer')->count()); ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('local-user-first-approve')): ?>
                                /<?php echo e(\App\Services\ClientServices::customerList('finalPendingCustomer')->count()); ?>

                            </span>
                        <?php endif; ?>
                    <?php else: ?>
                        <span class="badge  navbar-badge "
                            style="background:#e11d48 !important; color:white; font-size:12px !important;">
                            <?php echo e(\App\Services\ClientServices::customerList('pendingCustomer')->count()); ?>

                        </span>
                    <?php endif; ?>
                </a>

                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">

                    <a href="<?php echo e(route('pendingCustomer')); ?>" class="nav-link d-block dropdown-item" role="menuitem">
                        <i class="fa fa-table text-info"></i> Pending Customer
                        <span class="badge  text-light">
                            <?php echo e(\App\Services\ClientServices::customerList('pendingCustomer')->count()); ?>

                        </span>
                    </a>
                    <?php if(checkSettings('local-user-first-approve') == 'enable'): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('local-user-first-approve')): ?>
                            <a href="<?php echo e(route('pendingCustomer')); ?>" class="nav-link d-block dropdown-item"
                                role="menuitem">
                                <i class="fa fa-table"></i>Final Pending Customer
                                <span class="badge badge-warning text-light">
                                    <?php echo e(\App\Services\ClientServices::customerList('finalPendingCustomer')->count()); ?>

                                </span>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </span>
        </li>



            <li class="nav-item px-2 d-flex align-items-center">
                <button class="theme-toggle" id="themeToggle" title="Toggle dark mode">
                    <i class="fas fa-sun theme-icon sun-icon"></i>
                    <i class="fas fa-moon theme-icon moon-icon"></i>
                </button>
            </li>




        <li class="nav-tiem dropdown d-none d-xl-block " id="togglerIcon-desktop">

            <a class="nav-link  m-1 border " data-toggle="dropdown" href="#" id="toggleDropDown">
                <i class="fa-solid fa-circle-user icon-color " style="font-size:18px;"></i>
                <span style="text-transform: capitalize;"
                    class="admin-name"><?php echo e(Str::limit(auth()->user()->name, '10')); ?></span>
                <i class="fas fa-angle-down"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right " id="toggler">


                <div class="d-flex flex-column justify-content-between align-items-start py-3 "
                    style="row-gap: 2.5px;">

                    <div class="dropdown-item drop-border">
                        <div class="d-flex justify-content-start align-items-center" style="column-gap: 15px;">

                            <?php if(!empty(siteinfo())): ?>

                                <?php if(siteinfo()->img_url): ?>
                                    <div class="profile-image-container">
                                        <img src="<?php echo e(asset('storage/company/' . siteinfo()->img_url)); ?>"
                                            alt="" class="profile-image">
                                    </div>
                                <?php else: ?>
                                    <div class="profile-image d-flex justify-content-center align-items-center">
                                        <?php echo e(Str::substr(siteinfo()->name, 0, 2)); ?>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div>
                                <p style="text-transform: capitalize; font-size:18px; letter-spacing:0.05em;">
                                    <?php echo e(Str::limit(auth()->user()->name, '15')); ?></p>
                                <small><?php echo e(Auth::user()->getRoleNames()->first()); ?></small>
                            </div>
                        </div>
                    </div>

                    <a href="<?php echo e(route('user.edit', Auth::user()->id)); ?>" class="nav-link  dropdown-item"
                        role="menuitem">
                        <span style="text-transform: capitalize;"> <i
                                class="fa-solid fa-circle-user icon-color  mr-3"></i>
                            My Profile</span>
                    </a>

                    </a>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('password-change')): ?>
                        <a href="<?php echo e(route('passwordReset', Auth::user()->email)); ?>" class="nav-link  dropdown-item"
                            role="menuitem"><i class="fa fa-exchange-alt icon-color  mr-3"></i>Pasword Change</a>
                        </a>
                    <?php endif; ?>
                    

                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="nav-link dropdown-item text-start">
                        <?php echo csrf_field(); ?>
                        <i class="fa fa-sign-out-alt icon-color mr-2"></i>
                        <button type="submit" class="d-inline-block text-danger" id="logout-btn">Logout</button>
                        </a>
                    </form>
                </div>

            </div>
        </li>


    </ul>
</nav>
<!-- /.navbar -->


<style>
    .dropdown-menu-right {
        right: -30px;
    }

    .dropdown-menu-lg {

        max-width: 220px;
        min-width: 200px;
    }

    #logout-btn {
        border: none;
        background: inherit;
    }

    nav {
        font-family: "Nunito Sans", sans-serif !important;

        font-weight: 500;
    }

    .navbar-expand .navbar-nav .dropdown-menu {
        top: 54px;
    }

    .icon-color {
        color: #94a3b8;
    }

    .dropdown-menu>a {
        font-size: 16px;
    }

    .drop-border {
        border-bottom: 2px solid rgba(255, 193, 7, 0.25);

    }

    .profile-image {
        width: 36px;
        height: 36px;
        border-radius: 100%;
        border: 1px solid rgba(255, 193, 7, 0.80);
    }

    .profile-image-container {
        width: 38px;
        height: 38px;
        display: flex;
        justify-content: center;
        align-items: center;

    }

    .toggler-button {
        margin-left: 10px !important;
    }

    @media(max-width:1400px) {
        .admin-name {
            display: none !important;
        }
    }

    .noted {
        padding-right: 2.5px !important;
        padding-left: 2.5px !important;
    }

    #darkmode-toggle {
        background: transparent;
        color: #666;
        transition: all 0.3s ease;
        margin: 0 10px;
    }

    #darkmode-toggle:hover {
        background: rgba(0, 0, 0, 0.1);
    }

    #darkmode-toggle.active {
        color: #ffdd57;
    }

    .dark-icon,
    .light-icon {
        font-size: 18px;
    }

    .dark-mode-text {
        font-size: 14px;
        font-weight: 500;
    }

    #darkmode-toggle.active .dark-icon {
        display: none;
    }

    #darkmode-toggle.active .light-icon {
        display: inline-block !important;
    }

    /* Modern Dark Mode Toggle Styles */
    .dark-mode-toggle-wrapper {
        display: flex;
        align-items: center;
    }

    .dark-mode-toggle {
        background: transparent;
        border: none;
        padding: 0;
        cursor: pointer;
        position: relative;
        outline: none;
    }

    .toggle-track {
        width: 50px;
        height: 24px;
        background-color: #f3f4f6;
        /* Light gray background */
        border-radius: 12px;
        position: relative;
        transition: background-color 0.3s ease;
        display: flex;
        align-items: center;
        padding: 0 4px;
    }

    .toggle-icons {
        width: 100%;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: relative;
        z-index: 1;
    }

    .toggle-icons i {
        font-size: 12px;
        color: #64748b;
        transition: color 0.3s ease;
    }

    .toggle-thumb {
        width: 20px;
        height: 20px;
        background-color: white;
        border-radius: 50%;
        position: absolute;
        left: 2px;
        transition: transform 0.3s ease;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    }

    /* Active State */
    #darkmode-toggle.active .toggle-track {
        background-color: #4f46e5;
        /* Modern indigo color */
    }

    #darkmode-toggle.active .toggle-thumb {
        transform: translateX(26px);
    }

    #darkmode-toggle.active .toggle-icons .light-icon {
        color: #fef08a;
        /* Soft yellow/amber */
    }

    #darkmode-toggle.active .toggle-icons .dark-icon {
        color: #94a3b8;
        /* Slate gray */
    }

    #darkmode-toggle:not(.active) .toggle-icons .light-icon {
        color: #94a3b8;
        /* Slate gray */
    }

    #darkmode-toggle:not(.active) .toggle-icons .dark-icon {
        color: #334155;
        /* Darker slate */
    }

    /* Hover Effects */
    .toggle-track:hover {
        opacity: 0.9;
    }

    /* Focus State */
    #darkmode-toggle:focus .toggle-track {
        box-shadow: 0 0 0 2px rgba(79, 70, 229, 0.4);
        /* Matching indigo with opacity */
    }

    /* Animation */
    @keyframes  toggleMove {
        0% {
            transform: scale(1);
        }

        50% {
            transform: scale(0.9);
        }

        100% {
            transform: scale(1);
        }
    }

    #darkmode-toggle:active .toggle-thumb {
        animation: toggleMove 0.2s ease;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .toggle-track {
            width: 44px;
            height: 22px;
        }

        .toggle-thumb {
            width: 18px;
            height: 18px;
        }

        #darkmode-toggle.active .toggle-thumb {
            transform: translateX(22px);
        }
    }

    /* Updated dark mode toggle styles */
    .theme-toggle {
        padding: 8px;
        border-radius: 8px;
        background: transparent;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .theme-toggle:hover {
        background: rgba(67, 97, 238, 0.05);
    }

    .theme-icon {
        font-size: 1.25rem;
        position: absolute;
        transition: opacity 0.2s ease, transform 0.2s ease;
    }

    .sun-icon {
        color: #fbbf24;
        opacity: 0;
        transform: scale(0.5);
    }

    .moon-icon {
        color: #64748b;
        opacity: 1;
        transform: scale(1);
    }

    /* Dark mode states */
    .theme-toggle.dark-mode .sun-icon {
        opacity: 1;
        transform: scale(1);
    }

    .theme-toggle.dark-mode .moon-icon {
        opacity: 0;
        transform: scale(0.5);
    }

    /* Hover states */
    .theme-toggle:hover .moon-icon {
        color: #4338ca;
    }

    .theme-toggle.dark-mode:hover .sun-icon {
        color: #f59e0b;
    }
</style>
<?php /**PATH /var/www/html/ers/radius-circle/resources/views/layout/nav_lte.blade.php ENDPATH**/ ?>