<?php

namespace App\Services;

class NumberValidation
{
    /**
     * Validate the given number.
     *
     * @param  string  $number
     * @return bool
     */
    public function isBangladeshiNumber($number) {
        // Remove all non-digit characters
        $number = preg_replace('/\D/', '', $number);

        // Pattern: +8801XXXXXXXXX or 8801XXXXXXXXX or 01XXXXXXXXX
        return preg_match('/^(?:\+?88)?01[3-9]\d{8}$/', $number);
    }
}
