<div class="table-responsive">
    <table class="table table-bordered">
        <thead  style="background: #78716C;color:white;">
            <tr>
                <th scope="col" class="">
                    ID
                </th>

                <th scope="col" class="">
                    User name
                </th>

                <th scope="col" class="">
                    Expire Date
                </th>

                <th scope="col" class="">
                    Bill Cycle
                </th>

                @unlessrole('Sub Reseller')
                    <th scope="col" class="">
                        Package
                    </th>
                @endunlessrole
                <th scope="col" class="">
                    Sub Package
                </th>

                <th scope="col" class="">
                    Contact No
                </th>

                <th scope="col" class="">
                    action
                </th>
            </tr>
        </thead>
        <tbody class="">
            {{-- @dd($r) --}}
            @forelse ($r as $row)
                <tr>



                    <td>
                        {{-- {{$r}} --}}
                        {{ $row->id }}
                    </td>
                    <td>
                        {{ $row->userid }}
                    </td>

                    <td class="whitespace-nowrap">
                        {{ date('d-M-Y', strtotime($row->expire_date)) }}
                    </td>


                    <td>
                        {{ $row->billing_cycle }}
                    </td>
                    @unlessrole('Sub Reseller')
                        <td>
                            {{ $row->packages->package_name }}
                        </td>
                    @endunlessrole

                    <td>
                        @if ($row->subpack)
                            {{ $row->subpack->name }}
                        @endif
                    </td>

                    <td>
                        {{ $row->clientsinfo->contact_no ?? '' }}
                    </td>
                    <td class="px-6 text-left text-sm font-medium">




                        @if (!empty($packages))
                            <form action="{{ route('userPackageChange', $row->id) }}" method="POST"
                                class="flex flex-wrap">


                                @csrf
                                <input type="hidden" name="id" value="{{ $row->id }}">
                                <input type="hidden" id="uuid" name="uuid" value="{{createUUID()}}">

                                <div class="row">
                                    <div class="col-md-7">


                                        @if ($row->pop->subreseller == 'yes')
                                            <select name="package_id" class="form-control" required>
                                                <option value="">Select</option>
                                                @foreach ($packages as $p)
                                                    <option value="{{ $p->id }}"
                                                        @if ($p->id == $row->sub_package_id) selected @endif>
                                                        ({{ $p->id }})
                                                        - {{ $p->name }} @if (globalPermission('package-change-price-show'))
                                                            ({{ $p->rate }} TK)
                                                        @endif
                                                    </option>
                                                @endforeach

                                            </select>
                                        @else
                                            <select name="package_id" class="form-control" required>
                                                <option value="">Select</option>
                                                @foreach ($packages as $p)
                                                    <option value="{{ $p->id }}"
                                                        @if ($p->id == $row->package_id) selected @endif>
                                                        ({{ $p->id }})
                                                        - {{ $p->package_name }}
                                                        @if (globalPermission('package-change-price-show'))
                                                            ({{ $p->package_rate }} TK)
                                                        @endif
                                                    </option>
                                                @endforeach

                                            </select>
                                        @endif

                                    </div>
                                    <div class="col-md-5">
                                        <button type="submit" class="btn btn-primary">Change Package</button>
                                    </div>
                                </div>



                            </form>
                        @else
                            <form action="{{ route('userBillingCycleChange', $row->id) }}" method="POST"
                                class="flex flex-wrap">


                                @csrf
                                <input type="hidden" name="id" value="{{ $row->id }}">
                                <input type="hidden" id="uuid" name="uuid" value="{{createUUID()}}">
                                <div class="row">
                                    <div class="col-md-7">
                                        <select name="billCycle" class="form-control" required>
                                            <option value="">Select Date</option>
                                            @foreach (explode(',', $confday) as $item)
                                                <option value="{{ $item }}"
                                                    @if ($row->billing_cycle == $item) selected @endif>
                                                    {{ $item }}
                                                </option>
                                            @endforeach


                                        </select>
                                    </div>
                                    <div class="col-md-5">
                                        <button type="submit" class="btn btn-primary">Billing Cycle Change</button>
                                    </div>
                                </div>




                            </form>
                        @endif







                    </td>
                </tr>

            @empty

            @endforelse

            <!-- More items... -->
        </tbody>
    </table>
</div>
