@extends('layout.app')



@section('content')
    <div class="container">
        <div class="card">
            <div class="card-body">
                <form action="" id="search">
                    <div class="row">
                        <div class="col-sm">
                            <div class="form-group">
                                <label>Select Manager</label>
                                <select name="reseller" id="reseller" class="form-control form-control-sm select2">
                                    <option value="null">Select Manager</option>
                                    @foreach (userResellers() as $r)
                                        <option value="{{ $r->id }}">{{ $r->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm">
                            <label> Select POP </label>
                            <select name="pop" id="pop" class="form-control form-control-sm select2">
                                <option value="all"> Select One</option>
                            </select>
                        </div>
                        <div class="col-sm">
                            <div class="form-group">
                                <label for="">Start date</label>
                                <input type="date" name="start_date" class="form-control form-control-sm">
                            </div>
                        </div>

                        <div class="col-sm">
                            <div class="form-group">
                                <label for="">End date</label>
                                <input type="date" name="end_date" class="form-control form-control-sm">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group float-right mt-1">
                                <button class="btn btn-primary" type="submit" id="searchBtnDue"><i
                                        class="fa fa-search"></i>
                                    Search</button>
                                <a href="{{ url(request()->path()) }}" class="btn btn-info">Reset</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card d-none" id="resultCard">
        <div class="card-body">
            <div id="result">

            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        $(function() {

            $('#searchBtnDue').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();

                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('importClientsDueAmount') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').hide();
                        $('#resultCard').removeClass('d-none');
                    }
                });
            });

        });
    </script>
@endpush
