<?php $__env->startSection('content'); ?>

    <div class="card">

        <div class="card-body">
            <form action="#" id="search" class="paymentHistory">
                <h4 class="p-2 border-l"><?php echo e($page_title); ?></h4>

                <div class="row">
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="<?php echo e($start->format('m/d/y')); ?>"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="<?php echo e($end->format('m/d/y')); ?>"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Manager</label>
                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                <option value="">All Reseller</option>
                                <?php $__currentLoopData = $reseller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Sub-Manager/Pop</label>
                            <select name="pop_id" id="pop" class="select2 form-control">
                                <option value="">All Pops/Sub-manager</option>
                            </select>
                        </div>
                    </div>
                    <?php if(auth()->user()->hasRole('Admin')): ?>
                        <div class="col-md-2 col-sm-4">
                            <label>Select Area :</label>
                            <select name="area" id="area" class="form-control select2">
                                <option value="">Select Area</option>
                                <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($area->area); ?>"><?php echo e($area->area); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    <?php endif; ?>
                    <?php if(request()->routeIs(['paymentReport', 'paymentReportSearch'])): ?>

                    <?php if(!auth()->check() || ! auth()->user()->hasRole('Reseller')): ?>
                        <div class="col-md-2 col-sm-4">
                            <div class="form-group">
                                <label
                                    class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Collector</label>
                                <?php if(auth()->user()->hasrole('Admin')): ?>
                                    <select name="collected_by[]" class="select2 form-control" multiple>
                                        <option value="">Select Employee</option>
                                        <?php $__currentLoopData = employees(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($employee->admin == null || $employee->admin->user_accounting_status == 'yes'): ?>
                                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php else: ?>
                                    <?php if(auth()->user()->hasPermissionTo('change-collector')): ?>
                                        <select name="collected_by[]" class="select2 form-control" multiple>
                                            <option value="">Select Employee</option>
                                            <?php $__empty_1 = true; $__currentLoopData = employees(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php if($employee->admin == null || $employee->admin->user_accounting_status == 'yes'): ?>
                                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                        </select>
                                    <?php else: ?>
                                        <select name="collected_by[]" class="select2 form-control" multiple>
                                            
                                            <option value="">Select Employee</option>
                                            <?php $__empty_1 = true; $__currentLoopData = employees(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php if(
                                                    $employee->name == 'bkash' ||
                                                        $employee->name == 'Bkash-Online' ||
                                                        $employee->name == 'nagad' ||
                                                        $employee->name == 'Nagad-Online' ||
                                                        $employee->name == 'upay' ||
                                                        $employee->admin_user_id == auth()->user()->id): ?>
                                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                        </select>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-2 col-sm-4">
                            <div class="form-group">
                                <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Entry
                                    By</label>
                                <?php if(auth()->user()->hasrole('Admin')): ?>
                                    <select name="user_by[]" class="select2 form-control" multiple>
                                        <option value="">Select User</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($user->user_accounting_status == 'yes'): ?>
                                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php else: ?>
                                    <select name="user_by[]" class="select2 form-control" multiple>
                                        
                                        <option value="">Select User</option>
                                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php if($user->user_accounting_status == 'yes'): ?>
                                                <?php if(
                                                    $user->name == 'bkash' ||
                                                        $user->name == 'Bkash-Online' ||
                                                        $user->name == 'nagad' ||
                                                        $user->name == 'Nagad-Online' ||
                                                        $user->name == 'upay' ||
                                                        $user->id == auth()->user()->id): ?>
                                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?>
                                    </select>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>


                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Type</label>
                            <select name="type" class="select2 form-control">
                                <option value="">Select</option>
                                <option value="paid_amount">Paid Amount</option>
                                <option value="discount_amount">Discount</option>
                                <option value="advance_adjust">Advance Adjust</option>
                                
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group" style="margin-top:40px">
                            <input type="checkbox" name="with_close_id">
                            <span>Payment Report With Close Id</span>
                        </div>
                    </div>

                    <?php endif; ?>

                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <input type="hidden" name="otc" value="<?php echo e($otc); ?>">
                            <button @click="search" class="btn btn-primary" type="submit" id="paymentSearch"><i
                                    class="fa fa-search"></i> Search</button>

                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>


                </div>
            </form>




            <div id="result">

            </div>



        </div>

    </div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('ajax'); ?>
    
    <script>
        $(function() {

            $('#pop').select2();

            $('#reset').click(function() {
                $('#result').html('');
                $('.select2').val(null).trigger("change");
            });

            $('#reseller_id').on('change', function() {
                $("#loader").show();

                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getPopForManager')); ?>',
                    data: {
                        id: $(this).val()
                    },
                    success: function(data) {
                        $('#pop option').remove();
                        $('#pop').append(data);
                        $("#loader").hide();
                    }
                });


            });

            $('#payment_month').on('change', function() {
                var month = $('#payment_month').val();
                $('#description').val('Payment of month : ' + month + '. Bill Month : ' + month);
            });

            $('#paymentSearch').on('click', function(e) {
                $("#loader").show();
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('paymentReportSearch')); ?>',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $("#loader").hide();
                    }
                });

            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/extranet/radius-circle/resources/views/paymenthistory/index.blade.php ENDPATH**/ ?>