@extends('layout.app')

@section('content')
    <div class="card">
        @can('pop-recharge')
            <div class="card-body">
                <button type="button" class="btn btn-primary float-right poprecharge" data-toggle="modal"
                    data-target="#pop-recharge">
                    Pop Recharge
                </button>
            </div>
        @endcan
        <div class="card-body">
            <div class="table-responsive pt-2 " id="result">
                <table id="dataTable" class="display table table-bordered " style="width: 100% !important">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">
                            <th scope="col">Id</th>
                            <th scope="col"> POP Name </th>
                            @if (checkSettings('pop-online-recharge') == 'enable')
                                <th></th>
                            @endif
                            <th scope="col"> Manager Name </th>
                            <th scope="col"> POP Location </th>
                            @hasrole('Admin')
                                <th scope="col">NAS Server IP </th>
                            @endhasrole
                            <th scope="col"> POP Contact </th>
                            <th scope="col"> Sub-Manager </th>
                            @hasrole('Admin')
                                <th scope="col">Bill Generate </th>
                            @endhasrole
                            @canany(['show-pop-balance', 'specific_management_services'])
                                <th scope="col">Balance </th>
                            @endcan
                            @can('pop-disable')
                                <th scope="col">Pop Status</th>
                            @endcan
                            <th scope="col"> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php($checkAPI = checkAPI())
                        @foreach ($pop as $r)
                            <tr>
                                <td>
                                    {{ $r->id }}
                                </td>
                                <td>
                                    {{ $r->popname }}
                                </td>

                                @if (checkSettings('pop-online-recharge') == 'enable')
                                    {{-- @dd("comes"); --}}
                                    <td>
                                        @if ($r->enable_online_recharge)
                                            <a href="{{ route('onlinePopRecharge', $r->id) }}" class="btn btn-danger">Online
                                                Recharge</a>
                                        @endif
                                    </td>
                                @endif

                                <td>
                                    {{ $r->reseller->name ?? '' }}
                                </td>

                                <td>
                                    {{ $r->pop_location }}
                                </td>

                                @hasrole('Admin')
                                    <td>
                                        {{ $r->nas->nasname ?? '' }}
                                    </td>
                                @endhasrole




                                <td>
                                    {{ $r->pop_contact }}
                                </td>
                                <td>
                                    {{ $r->subreseller }}
                                </td>

                                {{-- <td>
                                    {{ $r->billable }}
                                </td> --}}
                                @hasrole('Admin')
                                    <td>
                                        {{ $r->bill_generate }}
                                    </td>
                                @endhasrole
                                @canany(['show-pop-balance', 'specific_management_services'])
                                    <td class="font-weight-bold border p-1 text-center ">
                                        @if ($r->subreseller == 'yes')
                                            {{ $r->balance->first()->amount ?? '' }}
                                        @endif
                                    </td>
                                @endcan


                                @can('pop-disable')
                                    <td>
                                        <div class="pop_disable_wrapper">
                                            @if ($r->pop_disable == 'no')
                                                {{-- <button data-id="{{ $r->id }}"
                                                    class="pop_disable btn btn-danger btn-xs">Disable Pop</button> --}}
                                                    <span class="badge badge-primary">Active</span>
                                            @endif

                                            @if ($r->pop_disable == 'yes')
                                                {{-- <button data-id="{{ $r->id }}"
                                                    class="pop_enable btn btn-success btn-xs">Enable Pop</button> --}}
                                                    <span class="badge badge-danger">Inactive</span>
                                            @endif
                                        </div>
                                    </td>
                                @endcan


                                <td class="whitespace-nowrap text-right text-sm font-medium">
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="btn-primary dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @can('sub-reseller-view-commission')
                                                <a class="dropdown-item"
                                                    href="{{ route('view-sub-reseller-commission', $r->id) }}">View Commission
                                                    History
                                                </a>
                                            @endcan
                                            @if ($r->subreseller == 'yes')
                                                @can('pop-recharge')
                                                    <a class="dropdown-item"
                                                        href="{{ route('subResellerRecharge', $r->id) }}">Recharge</a>
                                                @endcan
                                                @canany(['sub-package-permission', 'specific_management_services'])
                                                    <a class="dropdown-item"
                                                        href="{{ route('sub_package_permission', $r->id) }}">Sub Package
                                                        Permission</a>
                                                @endcan
                                            @endif
                                            @if (Auth()->user()->can('pop_edit') ||
                                                    Auth()->user()->can('pop-accounts-edit'))
                                                <a class="dropdown-item" href="{{ route('pop.edit', $r->id) }}">Edit</a>
                                            @endif




                                            @cannot('specific_management_services')
                                                @if ($checkAPI)
                                                    <form action="{{ route('syncPopWithMikrotik') }}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="pop_id" value="{{ $r->id }}">
                                                        <button type="submit" class="dropdown-item">Sync with Mikrotik</button>
                                                    </form>
                                                @else
                                                    <form action="{{ route('syncPopForRadius') }}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="pop_id" value="{{ $r->id }}">
                                                        <button type="submit" class="dropdown-item">Sync for radius</button>
                                                    </form>
                                                @endif
                                            @endcannot


                                            @can('pop-deactive')
                                                <a class="dropdown-item" href="{{ route('pop-deactive', $r->id) }}">Deactive
                                                    All Customer</a>
                                            @endcan
                                            @can('pop-close')
                                                <a class="dropdown-item" href="{{ route('pop-close', $r->id) }}">Close All
                                                    Customer</a>
                                            @endcan
                                            @can('view-pop-log-history')
                                                <a class="dropdown-item"
                                                    href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'POP']) }}">History</a>
                                            @endcan

                                            @can('pop-disable')
                                                @if ($r->pop_disable == 'no')
                                                    <button data-id="{{ $r->id }}"
                                                        class="pop_disable btn dropdown-item">Disable POP</button>
                                                @endif

                                                @if ($r->pop_disable == 'yes')
                                                    <button data-id="{{ $r->id }}"
                                                        class="pop_enable btn dropdown-item">Enable Pop</button>
                                                @endif
                                            @endcan



                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="pop-recharge">
        <div class="modal-dialog">
            <form action="{{ route('subRsellerRechargeUpdate') }}" method="POST" class="recharge-form">
                @csrf
                @method('post')
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Pop Recharge</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <div class="row">

                            <div class="col-md-4">Recharge To</div>

                            <div class="col-md-8 mb-2">
                                <select class="form-control select2" name="type_id" id="">
                                    <option value="">Select Pop</option>
                                    @foreach ($pop as $r)
                                        @if ($r->subreseller == 'yes')
                                            <option value="{{ $r->id }}">{{ $r->popname }}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>



                            <div class="col-md-4">Recharge Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" name="amount" class="form-control">
                            </div>

                            <div class="col-md-4">Remark</div>
                            <div class="col-md-8 mb-2">
                                <input type="text" name="remark" id="remark" class="form-control">

                            </div>

                            <input type="hidden" value="pop" name="type">


                        </div>


                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary recharge-submit" type="submit" id="modalSave"><i
                                class="fa fa-spin fa-spinner spinner"></i> Recharge</button>
                    </div>

                </div>
                <!-- /.modal-content -->
            </form>
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection

@unlessrole('Reseller')
    @section('ajax')
        <script>
            $(function() {

                $('#newDataTable').DataTable({
                    responsive: true,
                    "bProcessing": true,
                    "iDisplayLength": 100,
                    'order': [
                        [1, "asc"]
                    ]
                });

                $('.recharge-form').on('submit', function() {
                    $('.spinner').show();
                    $('.recharge-submit').attr('disabled', 'true');

                });

                $(document).on('click', '.pop_disable', function() {
                    if (confirm('Are you sure, you want to disable the pop??')) {


                        let id = $(this).data('id');
                        let section = $(this).closest('.pop_disable_wrapper');
                        startProcessing();
                        $.ajax({
                            type: 'post',
                            url: '{{ route('pop_disable') }}',
                            data: {
                                'id': id
                            },
                            success: function(data) {

                                stopProcessing();

                                if (data == 1) {
                                    section.html('<button data-id="' + id +
                                        '" class="pop_enable btn btn-success btn-xs">Enable Pop</button>'
                                    );
                                    toastr.success('Pop Disable Success!!');
                                }

                                if (data == 0) {
                                    toastr.error('Something is worng');
                                }
                            }
                        });

                    }
                });

                $(document).on('click', '.pop_enable', function() {
                    if (confirm('Are you sure, you want to Enable the pop??')) {
                        let id = $(this).data('id');
                        let section = $(this).closest('.pop_disable_wrapper');
                        startProcessing();
                        $.ajax({
                            type: 'post',
                            url: '{{ route('pop_enable') }}',
                            data: {
                                'id': id
                            },

                            success: function(data) {

                                stopProcessing();
                                if (data == 1) {

                                    section.html('<button data-id="' + id +
                                        '" class="pop_disable btn btn-danger btn-xs">Disable Pop</button>'
                                    );
                                    toastr.success('Pop Enable Success!!');
                                }

                                if (data == 0) {
                                    toastr.error('Something is worng');
                                }
                            }
                        });
                    }


                });

                var modalopen = "{{ session('modalopen') }}";

                if (modalopen == "true") {
                    $('.poprecharge').trigger('click');
                }

            });
        </script>
    @endsection
@endunlessrole
