@extends('layout.app')


@section('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Income List</h3>
                            <div class="card-tools">


                                {{-- <a href="{{ route('income-head.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;Income Head List</button></a> --}}


                                <a href="{{ route('income-head.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Income
                                        Type</button></a>


                                <a href="{{ route('income.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Income</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            {{-- <th>Income Head</th> --}}
                                            <th>Name</th>
                                            <th>Income Head</th>
                                            <th>Invoice Number</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Documents</th>
                                            <th>Description</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($incomes as $row)
                                            <tr>
                                                <td>{{ $row->id }}</td>
                                                {{-- <td>{{ $row->incomeHead}}</td> --}}
                                                <td>{{ $row->name }}</td>
                                                <td>{{ $row->head->name ?? '' }}</td>
                                                <td>{{ $row->invoice_number }}</td>
                                                <td>{{ $row->date }}</td>
                                                <td>{{ $row->amount }}</td>
                                                <td>

                                                   @if (!empty($row->attach_document))
                                                        @php
                                                            $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                                            $imgUrl = $isS3
                                                                ? $row->attach_document // already full URL from S3
                                                                : asset('storage/attachDocument/' . $row->attach_document); // local path
                                                        @endphp

                                                        <img src="{{ $imgUrl }}" width="auto" height="100" alt="Document">
                                                    @else
                                                        <p style="margin-inline: 10px">No File</p>
                                                    @endif
                                                </td>
                                                <td>{{ $row->description }}</td>

                                                <td>
                                                    @if (!in_array($row->incomeHead, [1, 2, 3, 4, 5]))
                                                        @can('income-section')
                                                            <div class="btn-group">
                                                                <a href="{{ route('income.edit', $row->id) }}"
                                                                    class="btn btn-sm btn-primary">
                                                                    <i class="fa fa-edit"></i>

                                                                </a>
                                                            </div>
                                                            @can('income-destroy')
                                                                <div class="btn-group">
                                                                    <form action="{{ route('income.destroy', $row) }}"
                                                                        method="POST">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button id="{{ $row->id }}"
                                                                            class="btn btn-sm btn-danger">Delete</button>
                                                                    </form>
                                                                </div>
                                                            @endcan
                                                        @endcan
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer">
                                {{ $incomes->links() }}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                </div>
            </div>
            <!-- /.row -->



        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('js')
    <!-- DataTables -->
    <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
@endsection
@push('script')
    <!-- page script -->
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@endpush
