@extends('layout.app')



@section('content')
    <div class="card">

        <div class="card-body">

            <form action="{{ route('payBiilLog.store') }}"  method="POST">
                @csrf

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    From Date
                                </label>
                                <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                    <input type="text" name="from_date" class="form-control datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                                </div>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                    To Date
                                </label>
                                <div class="input-group date" id="searchTo" data-target-input="nearest">
                                    <input type="text" name="to_date"  class="form-control datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group float-right mt-2">
                                <button class="btn btn-primary" type="submit" id="searchBtn">
                                    <i class="fa fa-search"></i> Search
                                    </button>

                            </div>
                        </div>

                    </div>

            </form>

            <div class="table-responsive">
                <table id="newDataTable" class="display table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Date</th>
                            <th>Payment Method</th>
                            <th>Request Url</th>
                            <th>Transection Id</th>
                            <th>Client Id</th>
                            <th>Rerquest Data</th>
                            <th>Response Data</th>
                            <th>Error Message</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($logs as $log)
                            <tr>
                                <td>{{ $log->created_at }}</td>
                                <td>{{ $log->payment_method }}</td>
                                <td>{{ $log->request_url }}</td>
                                <td>{{ $log->trxn_id }}</td>
                                <td>{{ $log->client_id }}</td>
                                <td>{{ $log->request }}</td>
                                <td>{{ $log->response }}</td>
                                <td>{{ $log->error_message }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


@endsection



@section('ajax')
    <script>
        $(function() {

            $('#newDataTable').DataTable({
                responsive: true,
                "bProcessing": true,
                "iDisplayLength": 100,
                'order': [
                    [1, "asc"]
                ]
            });

        });
    </script>
@endsection

