<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $info = collect(json_decode(siteinfo()->settings));
        $expire_sms_time = $info->where('type', 'expire_sms_send_time')->first()->value ?? '11:30';

        $expire_time = $info->where('type', 'expire_time')->first()->value ?? '00:00:00';

        if (globalPermission("onu_information_laser")){
            $schedule->command('snmp:process')->everyTenMinutes();
        }

        if ($expire_time == '00:00:00' || $expire_time == '0:0:00') {


            $schedule->command('expire:check')->daily();
            $schedule->command('expire:check')->dailyAt('1:00');
            $schedule->command('expire:check')->everySixHours();
        } else {
            $ex = explode(':', $expire_time);
            $schedule->command('expire:check')->hourlyAt($ex[1]);
        }

        // check customer active
        // $schedule->command('expire:recheck-active')->hourly();

        // $schedule->command('bandwidth:limit')->dailyAt('2:00');

        $schedule->command('check:auto-deactive')->dailyAt('00:20');

        $schedule->command('log:clear')->daily();

        // $schedule->command('database:backup')->twiceDaily(1, 13);

        if (getBillingType() != 'day_to_day') {
            if (today() == now()->firstOfMonth()) {
                $schedule->command('bill:generate')->dailyAt('1:10');
                $schedule->command('bill:generate')->dailyAt('13:10');
                $schedule->command('bill:generate')->dailyAt('18:10');
            }
        }



        $schedule->command('session:delete')->everyFiveMinutes();
        $schedule->command('expire-customer:deactive')->lastDayOfMonth()->at('02:10');

        $schedule->command('duplicate:delete')->hourly();

        $schedule->command('disablesecret:ifclientnotexist')->dailyAt('10:00');

        /**
         * Below Command will send sms for bill generate
         */

        if (today() == now()->firstOfMonth()) {
            $schedule->command('sms:billgenerate')->dailyAt('12:00');
        }


        /**
         * Below Commadn will check expire customer and send sms to them if they have due.
         */

        $schedule->command('expire:notification')->dailyAt('12:05');

        $schedule->command('sms:expired-customers')->dailyAt($expire_sms_time);


        /**
         * below command will run every day and update current license status to the system.
         */

        $schedule->command('license:check')->daily();


        /**
         * Below Command  will generate backup and clean old backup from server
         */
        $schedule->command('backup:clean --disable-notifications')->daily()->at('01:00');
        $schedule->command('backup:run')->daily()->at('04:55');
        if (globalPermission("static_ip_manage")) {
            $schedule->command('static:bind')->hourly();
        }

        if (checkSettings("api_bandwidth_usage") == 'enable') {
            $schedule->command('get:apibnadwidthusage')->everyFifteenMinutes();
        }

        if (checkSettings('ssl-commerz-live') == 'enable') {
            $schedule->command('check:payment-integration')->everyFiveMinutes();
        }

        if (checkSettings('ssl-reseller-recharge') == 'enable') {
            $schedule->command('ssl:reseller-recharge')->everyFiveMinutes();
        }

        if (checkSettings('nagad_pgw_implement_sync') == 'enable') {
            $schedule->command('nagad:pgw-payment-sync')->everyFifteenMinutes();
        }

        if (checkSettings('store_up_down_in_client_table') == 'enable') {
            $schedule->command('store:upload-download-to-client')->dailyAt("03:15");
        }

        if (!checkAPI()) {
            $schedule->command('disconnect:expireButOnlineRadiusCustomer')->hourly();
        }

        if (checkSettings('disable_limit_over_user') == 'enable') {
            $schedule->command('disable:limitOverUser')->dailyAt("10:15");
        }

        if (checkSettings('schedule_package') == 'enable') {
            $schedule->command('run:schedule-package-change')->dailyAt("23:50");
        }

        if (checkSettings('CRM') == 'enable') {
            if (today() == now()->firstOfMonth()) {
                $schedule->command('crm-status:marketing')->dailyAt("1:40");
            }
        }

        $schedule->command('store:client-summary')->daily()->at('23:58');


        //  $schedule->command('generate:token')->cron('0,40 * * * *');

          if(checkSettings('reseller-client-billing') == 'enable'){

             if (today() == now()->firstOfMonth()) {
                $schedule->command('reseller:bill-generate')->dailyAt('1:10');
                $schedule->command('reseller:bill-generate')->dailyAt('13:10');
                $schedule->command('reseller:bill-generate')->dailyAt('18:10');
            }

         }

         if(!checkAPI()){
            $schedule->command('sync:all-customer')->dailyAt('1:30');
            $schedule->command('sync:all-customer')->dailyAt('13:30');
         }

        if(today() == now()->firstOfMonth()){
            $schedule->command('employee:salary-generate')->dailyAt('2:10');
        }

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
