<?php

namespace App\Http\Controllers;

use App\Classes\EditLogHistory;
use App\Models\ClientReferer;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class MarketingUserController extends Controller
{

    public function index()
    {
        $list = ClientReferer::all();

        return view('mktuser.index', [
            'list' => $list
        ]);
    }

    public function create()
    {
        return view('mktuser.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'mfname' => 'required|string|max:255',
            'mlname' => 'required|string|max:255',
            'contact_no' => 'required|regex:/^[0-9]{11}$/|unique:client_references,contact_no',
        ], [
            'contact_no.required' => 'The contact number is required.',
            'contact_no.regex' => 'Please enter a valid 11-digit contact number.',
            'contact_no.unique' => 'This contact number is already taken by another user.',
        ]);

        if (!empty($request->mfname) && !empty($request->mlname) && !empty($request->contact_no)) {

            if (ClientReferer::where('contact_no', $request->contact_no)->count() < 1) {
                ClientReferer::insert([
                    'firstname' => $request->mfname,
                    'lastname'  => $request->mlname,
                    'user_id'   => auth()->id(),
                    'contact_no' => $request->contact_no
                ]);
                Toastr::success('Successfully Added');
            } else {
                $error = 'Duplicate Contact No';
                Toastr::error($error);
            }
        }

        return redirect()->route('marketing-user.index');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = ClientReferer::find($id);

        return view('mktuser.edit', [
            'data' => $data
        ]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'mfname' => 'required|string|max:255',
            'mlname' => 'required|string|max:255',
            'contact_no' => 'required|regex:/^[0-9]{11}$/|unique:client_references,contact_no,' . $id,
        ], [
            'contact_no.required' => 'The contact number is required.',
            'contact_no.regex' => 'Please enter a valid 11-digit contact number.',
            'contact_no.unique' => 'This contact number is already taken by another user.',
        ]);

        $type = 'MarketingUser';
        $old_info = ClientReferer::where('id', $id)->first();
        $user = ClientReferer::find($id);

        if ($user) {
            $user->firstname = $request->mfname;
            $user->lastname = $request->mlname;
            $user->user_id = auth()->id();
            $user->contact_no = $request->contact_no;
            $user->status = $request->status;
            $user->save();

            $new_info = ClientReferer::find($old_info->id);
            (new EditLogHistory)->editLogSave($old_info, $type, $old_info, $new_info);
            cache()->forget('referer');
            Toastr::success('Successfully Updated');
        } else {
            Toastr::error('User not found');
        }

        return redirect()->route('marketing-user.index');
    }

    public function destroy($id)
    {
        //
    }
}
