<div class="mb-2">
    <button class="btn btn-primary" onclick="export2csv()">Download csv</button>
</div>
<div class="col-md-12 mb-3">
    <div class="badge badge-info float-right m-1">Total Row: {{ $list->count() }}</div>
    <div class="badge badge-info float-right m-1">Total Amount: {{ number_format($list->sum('total_amount'), 2) }} TK
    </div>
    @can('show_commission_reseller_balance_log')
        <div class="badge badge-info float-right m-1">Total Commission (Fixed):
            {{ number_format($list->sum('total_commission_amount'), 2) }} TK</div>
    @endcan
    @can('show_commission_percentage_reseller_balance_log')
        <div class="badge badge-info float-right m-1">Total Commission (Calculated):
            {{ number_format($list->sum('calculated_commission_amount'), 2) }} TK</div>
    @endcan
</div>
<div class="table-responsive">
    <table class="table table-bordered table-striped table-condensed" id="tableId">
        <thead>
            <tr>
                <th>#</th>
                <th>Reseller Name</th>
                <th>Total Amount</th>
                <th>Commission in (%)</th>
                @can('show_commission_reseller_balance_log')
                    <th>Total Commission (Fixed)</th>
                @endcan
                @can('show_commission_percentage_reseller_balance_log')
                    <th>Total Commission (Calculated)</th>
                @endcan
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @php
                $total = 0;
                $totalCommission = 0;
                $totalCalculatedCommission = 0;
            @endphp
            @forelse ($list as $item)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $item->reseller->name ?? 'N/A' }}</td>
                    <td class="text-right">
                        @php $total += $item->total_amount @endphp
                        {{ number_format($item->total_amount, 2) }}
                    </td>
                    <td class="text-right">{{ $item->reseller->commission_percentage ?? 'N/A' }}</td>
                    @can('show_commission_reseller_balance_log')
                        <td class="text-right">
                            @php $totalCommission += $item->total_commission_amount @endphp
                            {{ number_format($item->total_commission_amount, 2) }}
                        </td>
                    @endcan
                    @can('show_commission_percentage_reseller_balance_log')
                        <td class="text-right">
                            @php $totalCalculatedCommission += $item->calculated_commission_amount @endphp
                            {{ number_format($item->calculated_commission_amount, 2) }}
                        </td>
                    @endcan
                </tr>
            @empty
            @endforelse
            <tr>
                <td></td>
                <td class="text-right">Total: </td>
                <td class="px-6 py-2 whitespace-nowrap text-right">{{ number_format($total, 2) }}</td>
                <td></td>
                @can('show_commission_reseller_balance_log')
                    <td class="px-6 py-2 whitespace-nowrap text-right">{{ number_format($totalCommission, 2) }}</td>
                @endcan
                @can('show_commission_percentage_reseller_balance_log')
                    <td class="px-6 py-2 whitespace-nowrap text-right">{{ number_format($totalCalculatedCommission, 2) }}
                    </td>
                @endcan
            </tr>
        </tbody>
    </table>
</div>
