import {
    Button,
    ButtonGroup,
    Col,
    Container,
    Form,
    Modal,
    Row,
    Table,
} from "react-bootstrap";
import { useDispatch, useSelector } from "react-redux";
import {
    deleteClusterFromMap,
    updateClusterInfo,
} from "../../../../../store/asyncMethods/clusterMethod";
import { setOpenClusterView } from "../../../../../store/reducers/currentClusterReducer";
import toast from "react-hot-toast";
import { useState } from "react";

function UpdateClusterInfo() {
    const [show, setShow] = useState(false);
    const dispatch = useDispatch();
    const { currentCluster: clusterInfo } = useSelector(
        ({ currentClusterReducer }) => currentClusterReducer
    );
    const [newClusterInfo, setNewClusterInfo] = useState({
        name: clusterInfo.name,
        isBox: clusterInfo.isBox,
        remarks: clusterInfo.remarks,
    });

    const onCheckBoxClickHandler = (event) => {
        setNewClusterInfo({ ...newClusterInfo, isBox: event.target.checked });
    };

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    const onChangeHandler = (event) => {
        setNewClusterInfo({
            ...newClusterInfo,
            [event.target.name]: event.target.value,
        });
    };

    const onSubmitHandler = (event) => {
        console.log("hello world");
        event.preventDefault();
        dispatch(
            updateClusterInfo(newClusterInfo, () => {
                setShow(false);
            })
        );
    };
    console.log(newClusterInfo, clusterInfo);
    return (
        <>
            <Button variant="warning" onClick={handleShow}>
                update
            </Button>
            <Modal show={show} onHide={handleClose}>
                <Modal.Header closeButton>
                    <Modal.Title>Cluster Info Update</Modal.Title>
                </Modal.Header>
                <Form onSubmit={onSubmitHandler}>
                    <Modal.Body>
                        <Form.Group className="mt-2">
                            <Form.Control
                                type="text"
                                placeholder="Enter Cluster Name"
                                onChange={onChangeHandler}
                                value={newClusterInfo.name}
                                name="name"
                            />
                        </Form.Group>
                        <Form.Group className="mt-2">
                            <Form.Check
                                type="checkbox"
                                label={`Is it box?`}
                                className="mt-1 ms-1"
                                onChange={onCheckBoxClickHandler}
                                checked={newClusterInfo.isBox}
                            />
                        </Form.Group>
                        <Form.Group className="mt-2">
                            <Form.Control
                                as="textarea"
                                placeholder="Remarks"
                                rows={3}
                                onChange={onChangeHandler}
                                value={newClusterInfo.remarks}
                                name="remarks"
                            />
                        </Form.Group>
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="secondary" onClick={handleClose}>
                            Close
                        </Button>
                        <Button variant="primary" type="submit">
                            Save Changes
                        </Button>
                    </Modal.Footer>
                </Form>
            </Modal>
        </>
    );
}

const ClusterInfo = () => {
    const dispatch = useDispatch();
    const { currentCluster: clusterInfo } = useSelector(
        ({ currentClusterReducer }) => currentClusterReducer
    );

    const onDeleteHandler = () => {
        if (!window.confirm("Are you sure you want to delete this cluster?"))
            return;
        dispatch(
            deleteClusterFromMap(() => {
                dispatch(setOpenClusterView(false));
                toast.success("Cluster deleted successfully");
            })
        );
    };

    return (
        <Container fluid>
            {" "}
            <Row>
                <Col className="bg-light rounded" lg={6}>
                    <Table striped bordered hover className="mt-3">
                        <tbody>
                            <tr>
                                <td>Cluster/Box ID</td>
                                <td>{clusterInfo.id}</td>
                            </tr>
                            <tr>
                                <td>Name</td>
                                <td>{clusterInfo.name}</td>
                            </tr>
                            <tr>
                                <td>Remarks</td>
                                <td>{clusterInfo.remarks}</td>
                            </tr>
                        </tbody>
                    </Table>
                    <ButtonGroup className="mb-2 btn-group-sm">
                        <UpdateClusterInfo />
                        <Button variant="danger" onClick={onDeleteHandler}>
                            Delete
                        </Button>
                    </ButtonGroup>
                </Col>
            </Row>
        </Container>
    );
};

export default ClusterInfo;
